% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setup.R
\name{set_optimizer}
\alias{set_optimizer}
\title{Specify numerical optimizer}
\usage{
set_optimizer(opt, f, p, v, z, ..., crit = character(0))
}
\arguments{
\item{opt}{An object of class \code{function}, a numerical optimizer.}

\item{f}{The name of the function input of \code{opt}.}

\item{p}{The name of the starting parameter values input of \code{opt}.}

\item{v}{The name of the optimal function value in the output list of \code{opt}.}

\item{z}{The name of the optimal parameter vector in the output list of \code{opt}.}

\item{...}{Additional arguments to be passed to the optimizer \code{opt}. Without
specifications, the default values of \code{opt} are used.}

\item{crit}{The names of additional elements in the output of \code{opt} to be saved
after the optimization.}
}
\value{
An object of class \code{optimizer}, which can be passed to
\code{\link{setup_ino}}.
}
\description{
Use this function to specify a numerical optimizer for the optimization
problem.
}
\details{
Numerical optimizer specified for the \code{opt} argument must fulfill the
following requirements:
\itemize{
\item it must have an input \code{f} for the function to be optimized,
\item it must have an input \code{p} for the starting parameter values,
\item it must have a \code{...} argument for additional parameters to
\code{f},
\item the output must be a named list, including the optimal function value
(named \code{v}) and parameter vector (named \code{z}).
}
}
\examples{
set_optimizer(
  opt = pracma::nelder_mead,
  f = "fn",
  p = "x0",
  v = "fmin",
  z = "xmin",
  tol = 1e-6,
  crit = c("xmin", "fcount")
)

}
\seealso{
\code{\link[=set_optimizer_nlm]{set_optimizer_nlm()}} and \code{\link[=set_optimizer_optim]{set_optimizer_optim()}}, two wrappers for the
\code{\link[stats]{nlm}} and \code{\link[stats]{optim}} optimizer.
}
\keyword{specification}
