% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/innsight.R
\docType{package}
\name{innsight-package}
\alias{innsight}
\alias{innsight-package}
\title{Get the insight of your neural network}
\description{
\code{innsight} is an R package that interprets the behavior and explains
individual predictions of modern neural networks. Many methods for
explaining individual predictions already exist, but hardly any of them
are implemented or available in R. Most of these so-called
\emph{feature attribution} methods are only implemented in Python and,
thus, difficult to access or use for the R community. In this sense,
the package \code{innsight} provides a common interface for various methods
for the interpretability of neural networks and can therefore be considered
as an R analogue to 'iNNvestigate' or 'Captum' for Python.
}
\details{
This package implements several model-specific interpretability
(feature attribution) methods based on neural networks in R, e.g.,
\itemize{
\item \emph{Layer-wise relevance propagation (\link{LRP})}
\itemize{
\item Including propagation rules: \eqn{\epsilon}-rule and
\eqn{\alpha}-\eqn{\beta}-rule
}
\item \emph{Deep learning important features (\link{DeepLift})}
\itemize{
\item Including propagation rules for non-linearities: \emph{Rescale} rule and
\emph{RevealCancel} rule
}
\item \link{DeepSHAP}
\item Gradient-based methods:
\itemize{
\item \emph{Vanilla \link{Gradient}}, including \emph{Gradient\eqn{\times}Input}
\item Smoothed gradients \emph{(\link{SmoothGrad})}, including \emph{SmoothGrad\eqn{\times}Input}
\item \emph{Integrated gradients} (\link{IntegratedGradient})
\item \emph{Expected gradients} (\link{ExpectedGradient})
}
\item \emph{\link{ConnectionWeights}}
\item Model-agnostic methods:
\itemize{
\item \emph{Local interpretable model-agnostic explanation (\link{LIME})}
\item \emph{Shapley values} (\link{SHAP})
}
}

The package \code{innsight} aims to be as flexible as possible and independent
of a specific deep learning package in which the passed network has been
learned. Basically, a neural network of the libraries
\code{\link[torch:nn_sequential]{torch::nn_sequential}}, \code{\link[keras:keras_model_sequential]{keras::keras_model_sequential}},
\code{\link[keras:keras_model]{keras::keras_model}} and \code{\link[neuralnet:neuralnet]{neuralnet::neuralnet}} can be passed to the
main building block \code{\link{Converter}},
which converts and stores the passed model as a torch model
(\code{\link{ConvertedModel}}) with special insights needed for interpretation.
It is also possible to pass an arbitrary net in form of a named list
(see details in \code{\link{Converter}}).

The scientific background and implementation details of \code{innsight} are
described in the paper "Interpreting Deep Neural Networks with the Package
innsight" by Koenen & Wright (2024), published in the
\emph{Journal of Statistical Software}. For a detailed explanation of the
methods and use cases, please refer to the publication
(doi: \doi{10.18637/jss.v111.i08}).
}
\references{
Koenen, N., & Wright, M. N. (2024). Interpreting Deep Neural Networks with
the Package innsight. Journal of Statistical Software, 111(8), 1-52. doi:
\doi{10.18637/jss.v111.i08}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://bips-hb.github.io/innsight/}
  \item \url{https://github.com/bips-hb/innsight/}
  \item Report bugs at \url{https://github.com/bips-hb/innsight/issues/}
}

}
\author{
\strong{Maintainer}: Niklas Koenen \email{niklas.koenen@gmail.com} (\href{https://orcid.org/0000-0002-4623-8271}{ORCID})

Other contributors:
\itemize{
  \item Raphael Baudeu \email{raphael.baudeu@gmail.com} [contributor]
}

}
