% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RmSmallCellChunks.R
\name{RmSmallCellChunks}
\alias{RmSmallCellChunks}
\title{Remove Small Cell Chunks}
\usage{
RmSmallCellChunks(r)
}
\arguments{
\item{r}{'RasterLayer'.
A raster grid layer with cell values.}
}
\value{
Returns a 'RasterLayer' object, \code{r} with cell values in the smaller cell chunks set to \code{NA}.
}
\description{
This function identifies cell chunks in a single raster grid layer,
where a cell chunk is defined as a group of connected cells with non-missing values.
The cell chunk with the largest surface area is preserved and all others removed.
}
\examples{
set.seed(10)
r <- raster::raster(ncols = 10, nrows = 10)
r[] <- round(runif(raster::ncell(r)) * 0.7)
r <- raster::clump(r)
raster::plot(r)

r.new <- RmSmallCellChunks(r)
raster::plot(r.new, zlim = range(r[], na.rm = TRUE))

}
\seealso{
\code{\link{clump}}
}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
\keyword{utilities}
