% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot.R
\name{gg.SpatialPolygons}
\alias{gg.SpatialPolygons}
\title{Geom for SpatialPolygons objects}
\usage{
\method{gg}{SpatialPolygons}(data, mapping = NULL, crs = NULL, ...)
}
\arguments{
\item{data}{A \code{SpatialPolygons} object.}

\item{mapping}{Aesthetic mappings created by \code{aes} used to update the default
mapping. The default mapping is
\code{ggplot2::aes(x = long, y = lat, group = group)}.}

\item{crs}{A \code{CRS} object defining the coordinate system to project the data to before plotting.}

\item{...}{Arguments passed on to \code{geom_polypath}.
Unless specified by the user,
the arguments \code{colour = "black"} (polygon colour) and
\code{alpha = 0.1} (Alpha level for polygon filling).}
}
\value{
A \code{ggpolypath::geom_polypath} object.
}
\description{
Uses the \code{ggplot2::fortify()} function to turn the \code{SpatialPolygons} objects into a
\code{data.frame}. Then
calls \code{geom_polygon} to plot the polygons. Requires the \code{ggplot2} package.
}
\details{
Requires the \code{ggpolypath} package to ensure proper plotting, since
the \code{ggplot::geom_polygon} function doesn't always handle geometries with
holes properly.
}
\examples{
\donttest{
  if (require(ggplot2, quietly = TRUE)) {
    # Load Gorilla data

    data("gorillas", package = "inlabru")

    # Plot Gorilla elevation covariate provided as SpatialPixelsDataFrame.
    # The same syntax applies to SpatialGridDataFrame objects.

    ggplot() +
      gg(gorillas$gcov$elevation)

    # Add Gorilla survey boundary and nest sightings

    ggplot() +
      gg(gorillas$gcov$elevation) +
      gg(gorillas$boundary) +
      gg(gorillas$nests)

    # Load pantropical dolphin data

    data("mexdolphin")

    # Plot the pantropiical survey boundary, ship transects and dolphin sightings

    ggplot() +
      gg(mexdolphin$ppoly) + # survey boundary as SpatialPolygon
      gg(mexdolphin$samplers) + # ship transects as SpatialLines
      gg(mexdolphin$points) # dolphin sightings as SpatialPoints

    # Change color

    ggplot() +
      gg(mexdolphin$ppoly, color = "green") + # survey boundary as SpatialPolygon
      gg(mexdolphin$samplers, color = "red") + # ship transects as SpatialLines
      gg(mexdolphin$points, color = "blue") # dolphin sightings as SpatialPoints


    # Visualize data annotations: line width by segment number

    names(mexdolphin$samplers) # 'seg' holds the segment number
    ggplot() +
      gg(mexdolphin$samplers, aes(color = seg))

    # Visualize data annotations: point size by dolphin group size

    names(mexdolphin$points) # 'size' holds the group size
    ggplot() +
      gg(mexdolphin$points, aes(size = size))
  }
}
}
\seealso{
Other geomes for spatial data: 
\code{\link{gg.SpatialGridDataFrame}()},
\code{\link{gg.SpatialLines}()},
\code{\link{gg.SpatialPixelsDataFrame}()},
\code{\link{gg.SpatialPixels}()},
\code{\link{gg.SpatialPoints}()},
\code{\link{gg}()},
\code{\link{gm}()}
}
\concept{geomes for spatial data}
