% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effect.R
\name{input_eval}
\alias{input_eval}
\alias{input_eval.component}
\alias{input_eval.component_list}
\alias{input_eval.bru_input}
\title{Obtain covariate values}
\usage{
input_eval(...)

\method{input_eval}{component}(component, data, ...)

\method{input_eval}{component_list}(components, data, ...)

\method{input_eval}{bru_input}(input, data, env = NULL, label = NULL, null.on.fail = FALSE, ...)
}
\arguments{
\item{...}{Unused.}

\item{component}{A component.}

\item{data}{A \code{data.frame} or Spatial* object of covariates and/or point locations. If null, return the component's map.}
}
\value{
An vector or a coordinate matrix
}
\description{
Obtain covariate values
}
\section{Simple covariates and the map parameter}{


It is not unusual for a random effect act on a transformation of a covariate. In other frameworks this
would mean that the transformed covariate would have to be calculated in advance and added to the
data frame that is usually provided via the \code{data} parameter. inlabru provides the option to do
this transformation automatically. For instance, one might be interested in the effect of a covariate
\eqn{x^2}. In inla and other frameworks this would require to add a column \code{xsquared} to the
input data frame and use the formula

\itemize{\item{\code{formula = y ~ f(xsquared, model = "linear")},}}

In inlabru this can be achived using two ways of using the \code{main} parameter
(\code{map} in version 2.1.13 and earlier).

\itemize{
\item{\code{components = y ~ psi(main = x^2, model = "linear")}}
\item{\code{components = y ~ psi(main = mySquareFun(x), model = "linear")},}
\item{\code{components = y ~ psi(main = myOtherSquareFun, model = "linear")},}

}

In the first example inlabru will interpret the map parameter as an expression to be evaluated within
the data provided. Since \eqn{x} is a knonwn covariate it will know how to calculate it. The second
example is an expression as well but it uses a function alled \code{mySquareFun}. This function is
defined by user but has wo be accessible within the work space when setting up the compoonents.
The third example provides the function \code{myOtherSquareFun} directly and not within an expression.
In this case, inlabru will call the function using the data provided via the  \code{data} parameter.
inlabru expects that the output of this function is a data.frame with "psi" being the name of the
single existing column. For instance,

\code{myOtherSquareFun = function(data) {
                            data = data[,"x", drop = FALSE] ;
                            colnames(data) = "psi" ;
                            return(data)}}
}

\section{Spatial Covariates}{


When fitting spatial models it is common to work with covariates that depend on space, e.g. sea
surface temperature or elevation. Although it is straight forward to add this data to the input
data frame or write a covariate function like in the previous section there is an even more
convenient way in inlabru. Spatial covariates are often stored as \code{SpatialPixelsDataFrame},
\code{SpatialPixelsDataFrame} or \code{RasterLayer} objects. These can be provided directly via
the map parameter if the input data is a \code{SpatialPointsDataFrame}. inlabru will automatically
evaluate and/or interpolate the coariate at your data locations when using code like

\itemize{\item{\code{components = y ~ psi(mySpatialPixels, model = "linear")}.}}
}

\section{Coordinates}{


A common spatial modelling component when using inla are SPDE models. An important feature of
inlabru is that it will automatically calculate the so called A-matrix which maps SPDE
values at the mesh vertices to values at the data locations. For this purpose, the map parameter
can be se to \code{coordinates}, which is the \code{sp} package function that extracts point
coordinates from the SpatialPointsDataFrame that was provided as input to bru. The code for
this would look as follows:

\itemize{\item{\code{components = y ~ mySPDE(main = coordinates, model = inla.spde2.matern(...))}.}}
}

\author{
Fabian E. Bachl \email{bachlfab@gmail.com}
}
\keyword{internal}
