% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mappers.R
\name{bru_mapper_logsumexp}
\alias{bru_mapper_logsumexp}
\alias{ibm_jacobian.bru_mapper_logsumexp}
\alias{ibm_eval.bru_mapper_logsumexp}
\title{Mapper for log-sum-exp aggregation}
\usage{
bru_mapper_logsumexp(rescale = FALSE, n_block = NULL)

\method{ibm_jacobian}{bru_mapper_logsumexp}(mapper, input, state = NULL, ...)

\method{ibm_eval}{bru_mapper_logsumexp}(mapper, input, state = NULL, log = TRUE, ..., sub_lin = NULL)
}
\arguments{
\item{rescale}{logical; For \code{bru_mapper_aggregate} and \code{bru_mapper_logsumexp},
specifies if the blockwise sums should be normalised by the blockwise weight
sums or not:
\itemize{
\item \code{FALSE}: (default) Straight weighted sum, no rescaling.
\item \code{TRUE}: Divide by the sum of the weight values within each block.
This is useful for integration averages, when the given weights are plain
integration weights. If the weights are \code{NULL} or all ones, this is
the same as dividing by the number of entries in each block.
}}

\item{n_block}{Predetermined number of output blocks. If \code{NULL}, overrides
the maximum block index in the inputs.}

\item{mapper}{A mapper S3 object, inheriting from \code{bru_mapper}.}

\item{input}{Data input for the mapper.}

\item{state}{A vector of latent state values for the mapping,
of length \code{ibm_n(mapper, inla_f = FALSE)}}

\item{...}{Arguments passed on to other methods}

\item{log}{logical; control \code{log} output. Default \code{TRUE}, see the \code{ibm_eval()} details
for \code{logsumexp} mappers.}

\item{sub_lin}{Internal, optional pre-computed sub-mapper information}
}
\description{
Constructs a mapper
that aggregates elements of \code{exp(state)}, with optional non-negative weighting,
and then takes the \code{log()}, so it can be used e.g.
for  \eqn{v_k=\log[\sum_{i\in I_k} w_i \exp(u_i)]}{log(blocksum(w*exp(state)))}
and \eqn{v_k=\log[\sum_{i\in I_k} w_i \exp(u_i) / \sum_{i\in I_k} w_i]}{log(blocksum(w*exp(state)/blocksum(w)))}
calculations.  Relies on the input handling methods for \code{bru_mapper_aggregate},
but also allows the weights to be supplied on a logarithmic scale as \code{log_weights}.
To avoid numerical overflow, it uses the common method of internally
shifting the state blockwise with
\code{(state-log_weights)[block] - max((state-log_weights)[block])},
and shifting the result back afterwards.
}
\details{
\itemize{
\item For \code{bru_mapper_logsumexp}, \code{input} should be a list with elements \code{block}
and \code{weights}. \code{block}
should be a vector of the same length as the \code{state}, or \code{NULL}, with \code{NULL}
equivalent to all-1.
If \code{weights} is \code{NULL}, it's interpreted as all-1.
}
}
\section{Methods (by generic)}{
\itemize{
\item \code{ibm_eval(bru_mapper_logsumexp)}: When \code{log} is \code{TRUE} (default), \code{ibm_eval()} for \code{logsumexp} returns
the log-sum-weight-exp value. If \code{FALSE}, the \code{sum-weight-exp} value is returned.

}}
\examples{
m <- bru_mapper_logsumexp()
ibm_eval2(m, list(block = c(1, 2, 1, 2), weights = 1:4), 11:14)

}
\seealso{
\link{bru_mapper}, \link{bru_mapper_generics}

Other mappers: 
\code{\link{bru_get_mapper}()},
\code{\link{bru_mapper.fm_mesh_1d}()},
\code{\link{bru_mapper.fm_mesh_2d}()},
\code{\link{bru_mapper_aggregate}()},
\code{\link{bru_mapper_collect}()},
\code{\link{bru_mapper_const}()},
\code{\link{bru_mapper_factor}()},
\code{\link{bru_mapper_generics}},
\code{\link{bru_mapper_harmonics}()},
\code{\link{bru_mapper_index}()},
\code{\link{bru_mapper_linear}()},
\code{\link{bru_mapper_marginal}()},
\code{\link{bru_mapper_matrix}()},
\code{\link{bru_mapper_mesh_B}()},
\code{\link{bru_mapper_multi}()},
\code{\link{bru_mapper_pipe}()},
\code{\link{bru_mapper_scale}()},
\code{\link{bru_mapper_shift}()},
\code{\link{bru_mapper_taylor}()},
\code{\link{bru_mapper}()}
}
\concept{mappers}
