% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_observations.R
\name{show_observations}
\alias{show_observations}
\title{Adds a Layer with Observations to a Profile Plot}
\usage{
show_observations(x, ..., size = 2, alpha = 1, color = "#371ea3",
  only_numerical = TRUE, variables = NULL)
}
\arguments{
\item{x}{a ceteris paribus explainer produced with function `ceteris_paribus()`}

\item{...}{other explainers that shall be plotted together}

\item{size}{a numeric. Size of lines to be plotted}

\item{alpha}{a numeric between 0 and 1. Opacity of lines}

\item{color}{a character. Either name of a color or name of a variable that should be used for coloring}

\item{only_numerical}{a logical. If TRUE then only numerical variables will be plotted. If FALSE then only categorical variables will be plotted.}

\item{variables}{if not NULL then only `variables` will be presented}
}
\value{
a ggplot2 layer
}
\description{
Function 'show_observations' adds a layer to a plot created with 'plot.ceteris_paribus_explainer' for selected observations.
Various parameters help to decide what should be plotted, profiles, aggregated profiles, points or rugs.
}
\examples{
library("DALEX")
 \dontrun{
library("titanic")
library("randomForest")

titanic_small <- titanic_train[,c("Survived", "Pclass", "Sex", "Age",
                                  "SibSp", "Parch", "Fare", "Embarked")]
titanic_small$Survived <- factor(titanic_small$Survived)
titanic_small$Sex <- factor(titanic_small$Sex)
titanic_small$Embarked <- factor(titanic_small$Embarked)
titanic_small <- na.omit(titanic_small)
rf_model <- randomForest(Survived ~ Pclass + Sex + Age + SibSp + Parch + Fare + Embarked,
                         data = titanic_small)
explainer_rf <- explain(rf_model, data = titanic_small,
                        y = titanic_small$Survived == "1", label = "RF")

selected_passangers <- select_sample(titanic_small, n = 100)
cp_rf <- ceteris_paribus(explainer_rf, selected_passangers)
cp_rf

plot(cp_rf, variables = "Age", color = "grey") +
show_observations(cp_rf, variables = "Age", color = "grey") +
  show_rugs(cp_rf, variables = "Age", color = "red")

}
}
