% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ceteris_paribus.R
\name{ceteris_paribus}
\alias{ceteris_paribus}
\alias{ceteris_paribus.explainer}
\alias{ceteris_paribus.default}
\title{Ceteris Paribus Profiles aka Individual Variable Profiles}
\usage{
ceteris_paribus(x, ...)

\method{ceteris_paribus}{explainer}(x, new_observation, y = NULL,
  variables = NULL, variable_splits = NULL, grid_points = 101, ...)

\method{ceteris_paribus}{default}(x, data, predict_function = predict,
  new_observation, y = NULL, variables = NULL,
  variable_splits = NULL, grid_points = 101, label = class(x)[1],
  ...)
}
\arguments{
\item{x}{a model to be explained, or an explainer created with the `DALEX::explain()` function.}

\item{...}{other parameters}

\item{new_observation}{a new observation with columns that corresponds to variables used in the model}

\item{y}{true labels for `new_observation`. If specified then will be added to ceteris paribus plots.}

\item{variables}{names of variables for which profiles shall be calculated. Will be passed to `calculate_variable_splits()`. If NULL then all variables from the validation data will be used.}

\item{variable_splits}{named list of splits for variables, in most cases created with `calculate_variable_splits()`. If NULL then it will be calculated based on validation data avaliable in the `explainer`.}

\item{grid_points}{number of points for profile. Will be passed to `calculate_variable_splits()`.}

\item{data}{validation dataset. It will be extracted from `x` if it's an explainer}

\item{predict_function}{predict function. It will be extracted from `x` if it's an explainer}

\item{label}{name of the model. By default it's extracted from the 'class' attribute of the model}
}
\value{
An object of the class 'ceteris_paribus_explainer'.
It's a data frame with calculated average responses.
}
\description{
This explainer works for individual observations.
For each observation it calculates Ceteris Paribus Profiles for selected variables.
Such profiles can be used to hypothesize about model results if selected variable is changed.
For this reason it is also called 'What-If Profiles'.
}
\details{
Find more detailes in \href{https://pbiecek.github.io/PM_VEE/ceterisParibus.html}{Ceteris Paribus Chapter}.
}
\examples{
library("DALEX")
# Toy examples, because CRAN angels ask for them
titanic <- na.omit(titanic)
model_titanic_glm <- glm(survived == "yes" ~ gender + age + fare,
                       data = titanic, family = "binomial")

explain_titanic_glm <- explain(model_titanic_glm,
                           data = titanic[,-9],
                           y = titanic$survived == "yes")
cp_rf <- ceteris_paribus(explain_titanic_glm, titanic[1,])
cp_rf
plot(cp_rf, variables = "age")

\donttest{
 library("randomForest")
 model_titanic_rf <- randomForest(survived ~ gender + age + class + embarked +
                                    fare + sibsp + parch,  data = titanic)
 model_titanic_rf

 explain_titanic_rf <- explain(model_titanic_rf,
                           data = titanic[,-9],
                           y = titanic$survived,
                           label = "Random Forest v7")

# select few passangers
selected_passangers <- select_sample(titanic, n = 20)
cp_rf <- ceteris_paribus(explain_titanic_rf, selected_passangers)
cp_rf

plot(cp_rf, variables = "age") +
  show_observations(cp_rf, variables = "age") +
  show_rugs(cp_rf, variables = "age", color = "red")

}
}
\references{
Predictive Models: Visual Exploration, Explanation and Debugging \url{https://pbiecek.github.io/PM_VEE}
}
