#' @details
#' The main function of the package is the \link{informSCI}-function for 
#' calculating informative lower simultaneous confidence bounds for a given 
#' graphical test procedure and given information weights. The 
#' \link{explore_q}-function can help to find the right information weights
#' for the \link{informSCI}-algorithm. The \link{inExactSCI}- and 
#' \link{notInExactSCI}-functions can help to determine how accurate a 
#' (numerical) approximation of the true informative lower SCI-bounds is.
#' @references F. Bretz, W. Maurer, W. Brannath, M. Posch: A graphical approach
#' to sequentially rejective multiple test procedures. Statistics in Medicine
#' 28.4 (2009), pp. 586-604.
#' 
#' K. Strassburger, F. Bretz: Compatible simultaneous lower confidence bounds 
#' for the Holm procedure and other Bonferroni based closed tests. Statistics 
#' in Medicine 27.4 (2008), pp. 4914-4927. 
#' S. Schmidt, W. Brannath: Informative Simultaneous Confidence Intervals
#' in Hierarchical Testing. Methods of Information in Medicine 53.4 (2014), 
#' pp. 278–283.
"_PACKAGE"

## usethis namespace: start
## usethis namespace: end
NULL
