% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{ivi.from.indices}
\alias{ivi.from.indices}
\alias{IVI.FI}
\title{Integrated Vector of Influence (IVI)}
\usage{
ivi.from.indices(DC, CR, LH_index, NC, BC, CI, scaled = TRUE)
}
\arguments{
\item{DC}{A vector containing the values of degree centrality of the desired vertices.}

\item{CR}{A vector containing the values of ClusterRank of the desired vertices.}

\item{LH_index}{A vector containing the values of local H-index of the desired vertices.}

\item{NC}{A vector containing the values of neighborhood connectivity of the desired vertices.}

\item{BC}{A vector containing the values of betweenness centrality of the desired vertices.}

\item{CI}{A vector containing the values of Collective Influence of the desired vertices.}

\item{scaled}{Logical; whether the end result should be 1-100 range normalized or not (default is TRUE).}
}
\value{
A numeric vector with the IVI values based on the provided centrality measures.
}
\description{
This function calculates the IVI of the desired nodes from previously calculated centrality
measures. This function is not dependent to other packages and the required centrality
measures, namely degree centrality, ClusterRank, betweenness centrality, Collective Influence,
local H-index, and neighborhood connectivity could have been calculated by any means beforehand.
}
\examples{
MyData <- centrality.measures
My.vertices.IVI <- ivi.from.indices(DC = centrality.measures$DC,
                                    CR = centrality.measures$CR,
                                    NC = centrality.measures$NC,
                                    LH_index = centrality.measures$LH_index,
                                    BC = centrality.measures$BC,
                                    CI = centrality.measures$CI)
}
\seealso{
\code{\link[influential]{ivi}}
}
\keyword{ivi.from.indices}
