% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network_evaluation.R
\name{calculate_metrics}
\alias{calculate_metrics}
\title{Calculate Network Prediction Performance Metrics}
\usage{
calculate_metrics(
  network_table,
  ground_truth,
  metric_type = c("all", "auc", "auroc", "auprc", "precision", "recall", "f1",
    "accuracy", "si", "ji"),
  return_plot = FALSE,
  line_color = "#1563cc",
  line_width = 1
)
}
\arguments{
\item{network_table}{A data frame of predicted network structure containing:
\itemize{
\item \emph{\code{regulator}} - Source nodes of the network edges
\item \emph{\code{target}} - Target nodes of the network edges
\item \emph{\code{weight}} - Edge weights representing prediction confidence
}}

\item{ground_truth}{A data frame of ground truth network with the same format as \emph{\code{network_table}}.}

\item{metric_type}{The type of metric to return, default is \emph{\code{all}}.
This can take any of the following choices:
\itemize{
\item \emph{\code{all}} - Returns all available metrics with \emph{Performance Metrics} plot
\item \emph{\code{auc}} - Returns both AUROC and AUPRC with their plots
\item \emph{\code{auroc}} - Area Under ROC Curve with plot
\item \emph{\code{auprc}} - Area Under Precision-Recall Curve with plot
\item \emph{\code{precision}} - Proportion of correct predictions among positive predictions
\item \emph{\code{recall}} - Proportion of actual positives correctly identified
\item \emph{\code{f1}} - Harmonic mean of precision and recall
\item \emph{\code{accuracy}} - Overall classification accuracy
\item \emph{\code{si}} - Set Intersection, counting correctly predicted edges
\item \emph{\code{ji}} - Jaccard Index, measuring overlap between predicted and true networks
}}

\item{return_plot}{Logical value, default is \emph{\code{FALSE}}, whether to generate visualization plots}

\item{line_color}{Color for plot lines, default is \emph{\verb{#1563cc}}}

\item{line_width}{Width for plot lines, default is \emph{\code{1}}}
}
\value{
A list containing:
\itemize{
\item \emph{\code{metrics}} - A data frame with requested metrics
\item \emph{\code{plot}} - A plot object if return_plot = TRUE (optional)
}
}
\description{
Calculates comprehensive performance metrics for evaluating predicted network structures,
including classification performance, precision-recall metrics, and network topology metrics.
}
\examples{
data("example_matrix")
data("example_ground_truth")
network_table <- inferCSN(example_matrix)
calculate_metrics(
  network_table,
  example_ground_truth,
  return_plot = TRUE
)
calculate_metrics(
  network_table,
  example_ground_truth,
  metric_type = "auroc"
)
}
