% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auc.calculate.R
\name{auc.calculate}
\alias{auc.calculate}
\title{AUC value calculate}
\usage{
auc.calculate(
  weightDT,
  groundTruth,
  plot = FALSE,
  lineColor = "#1563cc",
  lineWidth = 1
)
}
\arguments{
\item{weightDT}{The weight data table of network}

\item{groundTruth}{Ground truth for calculate AUC}

\item{plot}{If true, draw and print figure of AUC}

\item{lineColor}{The color of line in the figure}

\item{lineWidth}{The width of line in the figure}
}
\value{
AUC values and figure
}
\description{
AUC value calculate
}
\examples{
library(inferCSN)
data("exampleMatrix")
data("exampleGroundTruth")
weightDT <- inferCSN(exampleMatrix)
auc <- auc.calculate(weightDT, exampleGroundTruth, plot = TRUE)
head(auc)

}
