% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/v2_denue_stats.R
\name{denue_varios_stats}
\alias{denue_varios_stats}
\title{Returns statistics of coordinate}
\usage{
denue_varios_stats(data, col_lat, col_long, token, metros = 250,
  keyword = "todos")
}
\arguments{
\item{data}{data.frame with columns for latitud and longituds}

\item{col_lat}{number of column in data with latitud column}

\item{col_long}{number of column in data with longitud column}

\item{token}{API token supplied by INEGI}

\item{metros}{Distance in meters to search by coordinate}

\item{keyword}{Keyword of businesses to include. Defaults to all ("todos")}
}
\value{
Data.frame
}
\description{
Returns basic statistics of businesses, using DENUE, in the vecinity of coordinate.
}
\note{
Legacy function, will return data in spanish.
}
\examples{
\dontrun{
token<-"webservice_token"
df <- as.data.frame(latitud  = c(25.669194, 25.121194),
                  longitud = c(-100.30990, -99.81923))
stats <- denue_varios_stats(data     = df,
                          col_lat  = 1,
                          col_long = 2,
                          metros   = 500)
}
}
\author{
Eduardo Flores
}
