\name{plotniche}
\Rdversion{1.1}
\alias{plotniche}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Draws a single resource niche
}
\description{
Function \code{plotniche} draws a resource niche on the resource space computed by means of principal coordinates analysis. Resource relationships are given in distance matrix \code{D}, the species resource use is given in \code{P} and the availability of resources is given by vector \code{q}. 
}
\usage{
plotniche(P, D = NULL, q = NULL, mode = "multiple", Np = NULL, 
Nq = NULL, nboot = 1000, alpha=0.05, species=NULL, axes=c(1,2), 
chull=TRUE, bubbles=TRUE, writeName=FALSE, add=FALSE, col="black", lty=1,...)
}
\arguments{
  \item{P}{Data frame containing the relative or absolute usage that a set of species (in rows) make of a set of resources (in columns).}
  \item{D}{Object of type \code{\link{dist}} containing distance values between resources. If no distance matrix is provided (i.e. if \code{D==NULL}), the distances between resources is assumed to be maximum.}
  \item{q}{Vector with the availability of each resource.}
  \item{mode}{Either \code{mode = "single"} (rows of matrix P are individual observations to be pooled for a single niche) or \code{mode = "multiple"} (rows in P represent different niches).}
  \item{Np}{Vector with the number of observations per species from which the values in \code{P} come (in \code{mode = "multiple"}).}
  \item{Nq}{The number of observations per species from which the values in \code{q} come.}
  \item{nboot}{Number of boostrap samples used to compute bias-corrected percentile confidence intervals.}
  \item{alpha}{Used to set the confidence level (i.e. \code{alpha = 0.05} means 95 percent confidence interval).}
  \item{species}{Specifies which species niche is to be plot. This parameter is mandatory and can be either an numeric index or a string for a species name.}
  \item{axes}{PCoA axes used for plotting.}
  \item{chull}{ whether or not convex hulls should be drawn (only in \code{type="single"}).}
  \item{bubbles}{ draws bubbles proportional to resource preference data.}
  \item{writeName}{ flag indicating whether or not the name of the species should be drawn beside the centroid.}
  \item{col}{ color of the centroid and confidence interval arrows.}
  \item{lty}{ line type of the confidence interval arrows.}
  \item{add}{ if \code{TRUE}, the current plot is used. This is helpful to draw more than one species on the same plot (see examples).}
  \item{\dots}{ additional graphical parameters.}
}

\details{
The method is described in De Caceres et al. (in prep). If the distance matrix is not specified (i.e. if \code{D=NULL}) the function assumes that all resources are at a maximum distance (\code{d=1}). If the resource availability vector \code{q} is given then the values in \code{P} are taken as assessments of resource use and the species preference is calculated taking into account resource availability. Otherwise resource use is equated to resource preference. The function can also plot bootstrap confidence intervals following the bias-corrected percentile method (Manly 2007). If If \code{mode = "multiple"} and \code{Np != NULL}, bootstrap samples for a given species are generated assuming a multinomial distribution with the proportions calculated from the corresponding row values in \code{P}, and the number of observations comes from the corresponding element in \code{Np}. If \code{mode = "single"} then the bootstrapped units are the rows of matrix \code{P}. In both cases, if \code{Nq} is indicated, the availability of resources is also bootstrapped. The bias-corrected percentile method was described for overlap niche measures in Mueller and Altenberg (1985) and is extended here for all niche metrics except \code{nichearea}.
}

\references{
Mueller, L.D. and L. Altenberg. 1985. Statistical Inference on Measures of Niche Overlap. Ecology 66:1204-1210.

Manly, B.F.J. 2007. Randomization, bootstrap and Monte Carlo methods in biology. Chapman and Hall texts in statistical science series. 2nd edition.

De Caceres, M., Sol, D., Lapiedra, O. and P. Legendre. (2011) A framework for estimating niche metrics using the resemblance between qualitative resources. Oikos 120: 1341-1350.
}
\author{
Miquel De Caceres Ainsa, EMF-CREAF
}

\seealso{
See \code{\link{nichevar}} and \code{\link{nicheoverlap}} to obtain a resource niche metrics.
}
\examples{
# Loads example data
data(birds)

plotniche(birdsbreed, D = resourceD, mode="multiple", species=10) 
plotniche(birdsbreed, D = resourceD, mode="multiple", 
Np = rowSums(birdsbreed), Nq = 100, species=10) 
plotniche(birdsbreed, D = resourceD, 
q = c(0.18, 0.24, 0.22, 0.21, 0.15), mode="multiple", species=10)
plotniche(birdsbreed, D = resourceD, 
q = c(0.18, 0.24, 0.22, 0.21, 0.15), mode="multiple", 
Np = rowSums(birdsbreed), Nq = 100, species=10)

#draw two species
plotniche(birdsbreed, D = resourceD, mode="multiple", 
Np = rowSums(birdsbreed), Nq = 100, species=10, writeName=TRUE, 
bubbles=FALSE, chull=FALSE) 
plotniche(birdsbreed, D = resourceD,  mode="multiple", 
Np = rowSums(birdsbreed), Nq = 100, species=1, writeName=TRUE, 
bubbles=FALSE, chull=FALSE, add=TRUE, col="red", lty=2) 

}

