% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cumulate.R
\name{cumulate}
\alias{cumulate}
\alias{cumulate.default}
\alias{cumulate.incidence}
\title{Compute cumulative 'incidence'}
\usage{
cumulate(x)

\method{cumulate}{default}(x)

\method{cumulate}{incidence}(x)
}
\arguments{
\item{x}{An incidence object.}
}
\description{
\code{cumulate} is an S3 generic to compute cumulative numbers, with methods
for different types of objects:
}
\details{
\itemize{

\item default method is a wrapper for \code{cumsum}

\item \code{incidence} objects: computes cumulative incidence over time

\item \code{projections} objects: same, for \code{projections} objects,
implemented in the similarly named package; see \code{?cumulate.projections}
for more information, after loading the package

}
}
\examples{
dat <- as.integer(c(0,1,2,2,3,5,7))
group <- factor(c(1, 2, 3, 3, 3, 3, 1))
i <- incidence(dat, groups = group)
i
plot(i)

i_cum <- cumulate(i)
i_cum
plot(i_cum)

}
\seealso{
The \code{\link[=incidence]{incidence()}} function to generate the 'incidence'
objects.
}
\author{
Thibaut Jombart \email{thibautjombart@gmail.com}
}
