% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats-utility.R
\name{se}
\alias{se}
\title{Compute standard error of the mean.}
\usage{
se(x, na.rm = FALSE)
}
\arguments{
\item{x}{Numeric vector.}

\item{na.rm}{Logical, should NA value(s) be removed (FALSE by default)?}
}
\value{
Numeric vector with standard error of the mean
}
\description{
The standard error of the mean is computed as:
\eqn{\frac{\sigma(x)}{\sqrt{length(x)}}}, with:\cr
\eqn{\sigma(x)}: standard deviation of \code{x}
}
\examples{
se(rnorm(1000))
}
\seealso{
Other stats utility functions: 
\code{\link{cv}()},
\code{\link{geomCV}()},
\code{\link{geomMean}()},
\code{\link{geomSD}()},
\code{\link{geomSE}()}
}
\author{
Laure Cougnaud
}
\concept{stats utility functions}
