% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mdsPlot.R
\name{mdsPlot}
\alias{mdsPlot}
\title{mdsPlot}
\usage{
mdsPlot(
  x,
  Sample,
  Group,
  title,
  palette,
  maxOverlaps,
  sizeLabel,
  top,
  gene.selection
)
}
\arguments{
\item{x}{DGEList object from edgeR.}

\item{Sample}{A character vector of sample labels (one per column in  "x ").}

\item{Group}{A factor or character vector specifying the group/class of each sample.}

\item{title}{Plot title as a character string.}

\item{palette}{Name of a palette from the  "paletteer " package for coloring groups.}

\item{maxOverlaps}{Maximum number of overlapping labels allowed by  "geom_text_repel ".}

\item{sizeLabel}{Numeric value for label font size.}

\item{top}{Integer. Number of top most variable genes to include in MDS.}

\item{gene.selection}{Method for gene selection: one of "pairwise", "common", or "logFC".}
}
\value{
A  "ggplot " object representing the MDS plot.
}
\description{
Generate a multidimensional scaling (MDS) plot based on expression data.
}
\details{
This function performs MDS analysis using limma's  "plotMDS() " and visualizes
the sample relationships in two dimensions using  "ggplot2 " and  "ggrepel ".
}
