% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/na.seadec.R
\name{na.seadec}
\alias{na.seadec}
\title{Seasonally Decomposed Missing Value Imputation}
\usage{
na.seadec(data, algorithm, na.identifier = NA, ...)
}
\arguments{
\item{data}{Time Series (\code{\link{ts}}) object in which missing values are to be replaced}

\item{algorithm}{Algorithm to be used after decomposition. Accepts the following input:
\itemize{
   \item{"interpolation" - Imputation by Interpolation}
   \item{"locf" - Imputation by Last Observation Carried Forward}
   \item{"mean" - Imputation by Mean Value}
   \item{"random" - Imputation by Random Sample}
   }}

\item{na.identifier}{Missing Value Identifier. 
If another value than NA indicates missing values this can be specified here. 
Identifier can be a character string as well as a numeric value. No support for lists or vectors.}

\item{...}{Additional parameters for these algorithms that can be passed through. Look at \code{\link[imputeTS]{na.interpolation}}, \code{\link[imputeTS]{na.locf}},
\code{\link[imputeTS]{na.random}}, \code{\link[imputeTS]{na.mean}} for parameter options.}
}
\value{
Time Series (\code{\link{ts}}) object
}
\description{
Removes the seasonal component from the time series, performs imputation on the deseasonalized series and afterwards adds the seasonal component again.
}
\examples{
#Load dataset
require(datasets)
data(AirPassengers)
ap <- AirPassengers

#Insert NAs for testing purposes
ap[c(3,44,107)] <- NA

#Perform imputation using na.mean
na.seadec(data = ap, algorithm = "interpolation")


}
\author{
Steffen Moritz
}
\seealso{
\code{\link[imputeTS]{na.interpolation}}, \code{\link[imputeTS]{na.locf}},
 \code{\link[imputeTS]{na.random}}, \code{\link[imputeTS]{na.mean}}
}

