% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correct_heavy_REE.r
\name{correct_heavy}
\alias{correct_heavy}
\title{Corrects for the model deviations of Yb, Lu and Y}
\usage{
correct_heavy(
  dat,
  Y_correction_fact = 1.29,
  Yb_correction_fact = 1/0.8785,
  Lu_correction_fact = 1/0.8943
)
}
\arguments{
\item{dat}{A dataframe}

\item{Y_correction_fact}{a number: correction factor for underestimated Y. 1.29 by default.}

\item{Yb_correction_fact}{a number: correction factor for underestimated Yb 1/0.8785}

\item{Lu_correction_fact}{a number: correction factor for underestimated Lu 1/0.8943}
}
\value{
a data frame
}
\description{
Calculated value of Yb, Lu and Y slightly deviates from the linear regression. This function apply a correction to compensates those deviations. This function is wrapped inside model_REE()
}
