% Generated by roxygen2 (4.0.0): do not edit by hand
\name{mixGuess}
\alias{mixGuess}
\title{Naive imputation for mixed type data}
\usage{
mixGuess(missdata, method = c("mean", "majority"))
}
\arguments{
\item{missdata}{a data matrix with missing values}

\item{method}{a character vector of length 2 indicating which two methods to use
respectively for continuous variables and categorical variables. There are three options
for continous variables: "mean", "median" and "random", and two options for categorical
varaibles: "majority" and "random". The default method is "mean" for the continous part
and "majority" for the categorical part.}
}
\value{
the same size data matrix with no missing value.
}
\description{
Naive imputation for mixed type data
}
\examples{
data(tic)
\dontrun{
missdata <- SimIm(tic, 0.1)
require(cutoffR)
nmissing(missdata)
HeatStruct(missdata)
impdata <- mixGuess(missdata)
nmissing(impdata)
}
}

