% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl_impala.R
\name{impala_unnest}
\alias{impala_unnest}
\title{Unnest a complex column in an Impala table}
\usage{
impala_unnest(data, col, ...)
}
\arguments{
\item{data}{an object with class \code{tbl_impala}}

\item{col}{the unquoted name of an \code{ARRAY},
\code{MAP}, or \code{STRUCT} column}

\item{...}{ignored (included for compatibility)}
}
\value{
an object with class \code{tbl_impala} with the
complex column unnested into two or more separate columns
}
\description{
\describe{\code{impala_unnest()}}{ unnests a
column of type \code{ARRAY}, \code{MAP}, or \code{STRUCT}
in a \code{tbl_impala}. These column types are referred to
as complex or nested types.}
}
\details{
\code{impala_unnest()} currently can unnest only
one column, can only be applied once to a \code{tbl_impala},
and must be applied to a \code{tbl_impala} representing an
Impala table or view before applying any other operations.
}
\seealso{
\href{https://www.cloudera.com/documentation/enterprise/latest/topics/impala_complex_types.html}{
Impala Complex Types}
}
