% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{import_dataset}
\alias{import_dataset}
\title{Import datasets from accdata package}
\usage{
import_dataset(data)
}
\arguments{
\item{data}{A character string indicating which data to load. The currently
available datasets are "daily_acc_3d" and "daily_acc_7d".}
}
\value{
An object of class \code{impactr_data}.
}
\description{
A helper function to import datasets from the \code{accdata} package.
}
\details{
To import these datasets you need to install the \code{accdata}
package. It can be installed by running \code{install_accdata()}. The
datasets documentation can be accessed by \code{?accdata::`dataset_name`}
(e.g., \code{?accdata::daily_acc_3d}.
}
\examples{
# Ensure that {accdata} package is available before running the example.
# If it is not, run install_accdata() to install the required package.
if (requireNamespace("accdata", quietly = TRUE)) {
  data <- import_dataset("daily_acc_3d")
  data
}
}
