% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{flatten.alpha}
\alias{flatten.alpha}
\title{Flatten alpha channel}
\usage{
flatten.alpha(im, bg = "white")
}
\arguments{
\item{im}{an image (with 4 RGBA colour channels)}

\item{bg}{background: either an RGB image, or a vector of colour values, or a string (e.g. "blue"). Default: white background.}
}
\value{
a blended image
}
\description{
Flatten alpha channel
}
\examples{
#Add alpha channel
alpha <- Xc(grayscale(boats))/width(boats)
boats.a <- imlist(boats,alpha) \%>\% imappend("c")
flatten.alpha(boats.a) \%>\% plot
flatten.alpha(boats.a,"darkgreen") \%>\% plot
}
\seealso{
rm.alpha
}
\author{
Simon Barthelme
}
