% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splitcombine.R
\name{iiply}
\alias{iiply}
\title{Split an image, apply function, recombine the results as an image}
\usage{
iiply(im, axis, fun, ...)
}
\arguments{
\item{im}{image}

\item{axis}{axis for the split (e.g "c")}

\item{fun}{function to apply}

\item{...}{extra arguments to function fun}
}
\description{
This is just imsplit followed by llply followed by imappend
}
\examples{
parrots <- load.image(system.file('extdata/parrots.png',package='imager'))
#Normalise colour channels separately, recombine
iiply(parrots,"c",function(v) (v-mean(v))/sd(v)) \%>\% plot 

}

