% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{correlate}
\alias{correlate}
\title{Correlation of image by filter}
\usage{
correlate(im, filter, boundary_conditions = TRUE, normalise = FALSE)
}
\arguments{
\item{im}{an image}

\item{filter}{= the correlation kernel.}

\item{boundary_conditions}{= the border condition type (0=zero, 1=dirichlet)}

\item{normalise}{= normalise filter (default FALSE)}
}
\description{
The correlation of image im by filter flt is defined as:
 \eqn{res(x,y,z) = sum_{i,j,k} im(x + i,y + j,z + k)*flt(i,j,k).}
}
\examples{
#Edge filter
filter <- as.cimg(function(x,y) sign(x-5),10,10) 
layout(t(1:2))
#Convolution vs. correlation 
correlate(boats,filter) \%>\% plot(main="Correlation")
convolve(boats,filter) \%>\% plot(main="Convolution")
}

