% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lasso.R
\name{logit_lasso}
\alias{logit_lasso}
\title{Fit a logistic regression model using a design matrix}
\usage{
logit_lasso(X_tilde, y, lambda.min.ratio = 1e-04, nlambda = 100,
  lambda = NULL, delta = 0, alpha = NULL, R = NULL,
  funcR = function(G) {     abs(G)^2 }, maxit = 10000, eps = 1e-04,
  warm = "lambda", init.beta = NULL, strong = FALSE, sparse = FALSE,
  impl = "cpp", abs = TRUE)
}
\arguments{
\item{X_tilde}{standardized matrix of explanatory variables}

\item{y}{vector of objective variable}

\item{lambda.min.ratio}{ratio of max lambda and min lambda}

\item{nlambda}{the number of lambda (ignored if lambda is specified)}

\item{lambda}{lambda sequence}

\item{delta}{ratio of regularization (exclusive penalty / l1 penalty) (default: 0)}

\item{alpha}{mixing parameter of regularization of l1 and exclusive penalty terms (delta = (1 - alpha) / alpha)}

\item{R}{matrix using exclusive penalty term}

\item{funcR}{function of R (input: X, output: R)}

\item{maxit}{max iteration (default: 1e+4)}

\item{eps}{convergence threshold for optimization (default: 1e-4)}

\item{warm}{warm start direction: "lambda" (default) or "delta"}

\item{init.beta}{initial values of beta}

\item{strong}{whether use strong screening (default) or not}

\item{sparse}{whether use sparse matrix or not (default)}

\item{impl}{implementation language of optimization: "cpp" (default) or "r"}

\item{abs}{(experimental) whether use absolute value of beta (default) or not}
}
\value{
lasso model
\item{beta_standard}{standardized coefficients}
\item{lambda}{regularization parameters}
\item{alpha}{alpha defined above}
\item{delta}{delta defined above}
}
\description{
Fit a logistic regression model using a design matrix
}
\examples{
X <- matrix(c(1,2,3,5,4,7,6,8,9,10), nrow=5, ncol=2)
b <- matrix(c(-1,1), nrow=2, ncol=1)
e <- matrix(c(0,-0.1,0.1,-0.1,0.1), nrow=5, ncol=1)
y <- as.numeric(X \%*\% b + e)
y <- ifelse(y>mean(y), 1, 0)
fit <- lasso(X, y, family="binomial")
pr <- predict_lasso(fit, X)
plot_lasso(fit)
}
