% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trees.R
\name{sample_spanning_tree}
\alias{sample_spanning_tree}
\title{Samples from the spanning trees of a graph randomly and uniformly}
\usage{
sample_spanning_tree(graph, vid = 0)
}
\arguments{
\item{graph}{The input graph to sample from. Edge directions are ignored if
the graph is directed.}

\item{vid}{When the graph is disconnected, this argument specifies how to
handle the situation. When the argument is zero (the default), the sampling
will be performed component-wise, and the result will be a spanning forest.
When the argument contains a vertex ID, only the component containing the
given vertex will be processed, and the result will be a spanning tree of the
component of the graph.}
}
\value{
An edge sequence containing the edges of the spanning tree. Use
\code{\link[=subgraph.edges]{subgraph.edges()}} to extract the corresponding subgraph.
}
\description{
\code{sample_spanning_tree()} picks a spanning tree of an undirected graph
randomly and uniformly, using loop-erased random walks.
}
\examples{

g <- make_full_graph(10) \%du\% make_full_graph(5)
edges <- sample_spanning_tree(g)
forest <- subgraph.edges(g, edges)

}
\seealso{
\code{\link[=subgraph.edges]{subgraph.edges()}} to extract the tree itself

Other trees: 
\code{\link{is_tree}()},
\code{\link{to_prufer}()}
}
\concept{trees}
\keyword{graph}
