% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/layout.R
\name{layout_as_bipartite}
\alias{as_bipartite}
\alias{layout.bipartite}
\alias{layout_as_bipartite}
\title{Simple two-row layout for bipartite graphs}
\usage{
layout_as_bipartite(graph, types = NULL, hgap = 1, vgap = 1,
  maxiter = 100)

as_bipartite(...)
}
\arguments{
\item{graph}{The bipartite input graph. It should have a logical
\sQuote{\code{type}} vertex attribute, or the \code{types} argument must be
given.}

\item{types}{A logical vector, the vertex types. If this argument is
\code{NULL} (the default), then the \sQuote{\code{type}} vertex attribute is
used.}

\item{hgap}{Real scalar, the minimum horizontal gap between vertices in the
same layer.}

\item{vgap}{Real scalar, the distance between the two layers.}

\item{maxiter}{Integer scalar, the maximum number of iterations in the
crossing minimization stage. 100 is a reasonable default; if you feel that
you have too many edge crossings, increase this.}

\item{...}{Arguments to pass to \code{layout_as_bipartite}.}
}
\value{
A matrix with two columns and as many rows as the number of vertices
in the input graph.
}
\description{
Minimize edge-crossings in a simple two-row (or column) layout for bipartite
graphs.
}
\details{
The layout is created by first placing the vertices in two rows, according
to their types. Then the positions within the rows are optimized to minimize
edge crossings, using the Sugiyama algorithm (see
\code{\link{layout_with_sugiyama}}).
}
\examples{
# Random bipartite graph
inc <- matrix(sample(0:1, 50, replace = TRUE, prob=c(2,1)), 10, 5)
g <- graph_from_incidence_matrix(inc)
plot(g, layout = layout_as_bipartite,
     vertex.color=c("green","cyan")[V(g)$type+1])

# Two columns
g \%>\%
  add_layout_(as_bipartite()) \%>\%
  plot()
}
\author{
Gabor Csardi \email{csardi.gabor@gmail.com}
}
\seealso{
\code{\link{layout_with_sugiyama}}

Other graph layouts: \code{\link{add_layout_}};
  \code{\link{as_star}}, \code{\link{layout.star}},
  \code{\link{layout_as_star}}; \code{\link{as_tree}},
  \code{\link{layout_as_tree}};
  \code{\link{component_wise}}; \code{\link{in_circle}},
  \code{\link{layout_in_circle}};
  \code{\link{layout.auto}}, \code{\link{layout_nicely}},
  \code{\link{nicely}};
  \code{\link{layout.davidson.harel}},
  \code{\link{layout_with_dh}}, \code{\link{with_dh}};
  \code{\link{layout.gem}}, \code{\link{layout_with_gem}},
  \code{\link{with_gem}}; \code{\link{layout.graphopt}},
  \code{\link{layout_with_graphopt}},
  \code{\link{with_graphopt}}; \code{\link{layout.grid}},
  \code{\link{layout.grid.3d}},
  \code{\link{layout.grid.3d}},
  \code{\link{layout_on_grid}}, \code{\link{on_grid}};
  \code{\link{layout.mds}}, \code{\link{layout_with_mds}},
  \code{\link{with_mds}}; \code{\link{layout.merge}},
  \code{\link{layout_components}},
  \code{\link{merge_coords}},
  \code{\link{piecewise.layout}},
  \code{\link{piecewise.layout}};
  \code{\link{layout.norm}}, \code{\link{norm_coords}};
  \code{\link{layout.sugiyama}},
  \code{\link{layout_with_sugiyama}},
  \code{\link{with_sugiyama}};
  \code{\link{layout_on_sphere}}, \code{\link{on_sphere}};
  \code{\link{layout_randomly}}, \code{\link{randomly}};
  \code{\link{layout_with_fr}}, \code{\link{with_fr}};
  \code{\link{layout_with_kk}}, \code{\link{with_kk}};
  \code{\link{layout_with_lgl}}, \code{\link{with_lgl}};
  \code{\link{layout}}, \code{\link{layout_}},
  \code{\link{print.igraph_layout_modifier}},
  \code{\link{print.igraph_layout_spec}};
  \code{\link{normalize}}
}
\keyword{graphs}

