% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep_unlabeled_graph.R
\name{prep_unlabeled_graph}
\alias{prep_unlabeled_graph}
\title{Prepared Unlabeled Graph to work with Degree-Betweenness Algorithm}
\usage{
prep_unlabeled_graph(graph)
}
\arguments{
\item{graph}{an unlabeled graph.}
}
\value{
An "igraph" object with named vertices.
}
\description{
Presently, \code{cluster_degree_betweenness()} function only works with labeled graphs. \code{prep_unlabeled_graph()} is a utility function that gives an unlabeled graph labels which are string values of their vertices.
}
\examples{
library(igraph)
library(igraphdata)
library(ig.degree.betweenness)
data("UKfaculty")
# Making graph undirected so it looks nicer when its plotted
uk_faculty <- prep_unlabeled_graph(UKfaculty) |>
  as.undirected()

ndb <- cluster_degree_betweenness(uk_faculty)

plot(
ndb,
uk_faculty,
main= "Node Degree Clustering"
)

ndb
}
\seealso{
[cluster_degree_betweenness()] which this function aids.
}
