% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shm.R
\encoding{UTF-8}
\name{shm}
\alias{shm}
\title{Harmonic mean}
\usage{
shm(x, na.rm = FALSE)
}
\arguments{
\item{x}{numeric vector that contains the sample data points.}

\item{na.rm}{logical vector that determines whether the missing
values should be removed or not.}
}
\value{
sample harmonic mean as a numeric vector. The default choice is that
  any NA values will be kept (\code{na.rm = FALSE}). This can be changed by
  specifying \code{na.rm = TRUE}, such as \code{shm(x, na.rm = TRUE)}.
}
\description{
This function computes the sample harmonic mean.
}
\details{
Harmonic mean is expressed as

\deqn{\bar{x}_h = \frac{1}{\left(\frac{1}{n}\right)\left[\left(\frac{1}{x_1}\right) + \left(\frac{1}{x_2}\right) + \cdots + \left(\frac{1}{x_n}\right)\right]}}

\describe{
\item{\emph{\eqn{\bar{x}_h}}}{the sample harmonic mean}
\item{\emph{x}}{the values in a sample}
\item{\emph{n}}{the number of values}
}

  "The harmonic mean is the reciprocal of the mean of the reciprocals. It is
  applied in situations where the reciprocal of a variable is averaged."
}
\examples{
library("iemisc")
library("data.table")

# Example 1.12 from Kottegoda (page 13)
x <- c(0.20, 0.24, 0.16) # stream velocities in m/s
shm(x)

# using a matrix of the numeric vector x
mat1 <- matrix(data = x, nrow = length(x), ncol = 1, byrow = FALSE,
        dimnames = list(c(rep("", length(x))), "Velocities"))
shm(mat1)


# using a data.frame of the numeric vector x
df1 <- data.frame(x)
shm(df1)


# using a data.table of the numeric vector x
df2 <- data.table(x)
shm(df2)


}
\references{
Nathabandu T. Kottegoda and Renzo Rosso, \emph{Statistics, Probability, and Reliability for Civil and Environmental Engineers}, New York City, New York: The McGraw-Hill Companies, Inc., 1997, page 13.
}
\seealso{
\code{\link[base]{mean}} for arithmetic mean

\code{\link{sgm}} for geometric mean, \code{\link{cv}} for coefficient of
 variation (CV), \code{\link{relerror}} for relative error, \code{\link{approxerror}} for
 approximate error, \code{\link{rms}} for root-mean-square (RMS), and \code{\link{ranges}}
 for sample range.
}
