% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cosd.R
\encoding{UTF-8}
\name{cosd}
\alias{cosd}
\title{Cosine (in degrees) [GNU Octave/MATLAB compatible]}
\usage{
cosd(x)
}
\arguments{
\item{x}{A numeric vector containing values in degrees}
}
\value{
The cosine of each element of \code{x} in degrees. Zero for any
"elements where (\code{x} - 90) / 180 is an integer."
}
\description{
Calculates the value of cosine for each element of \code{x} in degrees in a
manner compatible with GNU Octave/MATLAB. Zero is returned for any "elements
where (\code{x} - 90) / 180 is an integer." Source: Eaton.
}
\examples{
library(iemisc)

# Examples from GNU Octave cosd
cosd(seq(0, 80, by = 10))

cosd(pi * seq(0, 80, by = 10) / 180)

cosd(c(0, 180, 360))

cosd(c(90, 270, 45))


}
\author{
David Bateman (GNU Octave cosd), Irucka Embry
}
\references{
John W. Eaton, David Bateman, and Søren Hauberg (2009). \emph{GNU Octave version 3.0.1 manual: a high-level interactive language for numerical computations}. CreateSpace Independent Publishing Platform. ISBN 1441413006, URL \url{http://www.gnu.org/software/octave/doc/interpreter/}. Page 358.
}

