% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa-generics-volume.R
\name{plot.ieegio_volume}
\alias{plot.ieegio_volume}
\title{Plot '3D' volume in anatomical slices}
\usage{
\method{plot}{ieegio_volume}(
  x,
  position = c(0, 0, 0),
  center_position = FALSE,
  which = c("coronal", "axial", "sagittal"),
  slice_index = 1L,
  transform = "vox2ras",
  zoom = 1,
  pixel_width = max(zoom/2, 1),
  crosshair_gap = 4,
  crosshair_lty = 2,
  col = c("black", "white"),
  crosshair_col = "#00FF00A0",
  continuous = TRUE,
  vlim = NULL,
  add = FALSE,
  main = "",
  axes = FALSE,
  background = col[[1]],
  foreground = col[[length(col)]],
  ...,
  .xdata = x$data
)
}
\arguments{
\item{x}{\code{'ieegio_volume'} object; see \code{\link{read_volume}}}

\item{position}{cross-hair focused position}

\item{center_position}{whether to center canvas at \code{position},
default is \code{FALSE}}

\item{which}{which slice to plot; choices are \code{"coronal"},
\code{"axial"}, and \code{"sagittal"}}

\item{slice_index}{length of 1: if \code{x} has fourth dimension
(e.g. 'fMRI'), then which slice index to draw}

\item{transform}{which transform to apply, can be a 4-by-4 matrix,
an integer or name indicating the matrix in \code{x$transforms}; this needs
to be the transform matrix from voxel index to 'RAS'
(right-anterior-superior coordinate system), often called \code{'xform'},
\code{'sform'}, \code{'qform'} in 'NIfTI' terms, or \code{'Norig'} in
'FreeSurfer'}

\item{zoom}{zoom-in level}

\item{pixel_width}{pixel size, ranging from \code{0.05} to \code{50};
default is the half of \code{zoom} or \code{1}, whichever is greater;
the unit of \code{pixel_width} divided by \code{zoom} is milliliter}

\item{crosshair_gap}{the cross-hair gap in milliliter}

\item{crosshair_lty}{the cross-hair line type}

\item{col}{color palette for continuous \code{x} values}

\item{crosshair_col}{the cross-hair color; set to \code{NA} to hide}

\item{continuous}{reserved}

\item{vlim}{the range limit of the data; default is computed from range of
\code{x$data}; data values exceeding the range will be trimmed}

\item{add}{whether to add the plot to existing underlay;
default is \code{FALSE}}

\item{main, ...}{passed to \code{\link[graphics]{image}}}

\item{axes}{whether to draw axes; default is \code{FALSE}}

\item{background, foreground}{background and foreground colors; default is
the first and last elements of \code{col}}

\item{.xdata}{default is \code{x$data}, used to speed up the calculation
when multiple different angles are to be plotted}
}
\description{
Plot '3D' volume in anatomical slices
}
\examples{

library(ieegio)

nifti_file <- "brain.demosubject.nii.gz"

# Use `ieegio_sample_data(nifti_file)`
#   to download sample data


if( ieegio_sample_data(nifti_file, test = TRUE) ) {

# ---- NIfTI examples ---------------------------------------------

file <- ieegio_sample_data(nifti_file)

# basic read
vol <- read_volume(file)

par(mfrow = c(1, 3), mar = c(0, 0, 3.1, 0))

ras_position <- c(-50, -10, 15)

ras_str <- paste(sprintf("\%.0f", ras_position), collapse = ",")

for(which in c("coronal", "axial", "sagittal")) {
  plot(x = vol, position = ras_position, crosshair_gap = 10,
       crosshair_lty = 2, zoom = 3, which = which,
       main = sprintf("\%s T1RAS=[\%s]", which, ras_str))
}


}

}
