% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SEIRS.R
\name{SEIRS_demographics_ode}
\alias{SEIRS_demographics_ode}
\title{Susceptible-Exposed-Infected-Recovered-Susceptible Model with Simple Demographics}
\usage{
SEIRS_demographics_ode(t, x, params)
}
\arguments{
\item{t}{The timestep over which to calculate derivatives}

\item{x}{A numeric vector of compartment populations.}

\item{params}{A named vector of parameter values.}
}
\value{
A vector of derivatives
}
\description{
Susceptible-Exposed-Infected-Recovered-Susceptible Model with Simple Demographics
}
\examples{
##Model Input
S_0 <- 989
E_0 <- 10
I_0 <- 1
R_0 <- 0
beta <- 3
gamma <-  1/2
tau <- 2
chi <- 0.5
mu <- 1/81

parameters <- c(beta = beta, gamma = gamma, chi = chi,
                tau = tau, mu = mu)
inits <- c(S = S_0, E = E_0, I = I_0, R_0 = R_0)

SEIRS_demographics_ode(1, inits, parameters)
}
