% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SHLITR.R
\name{SHLITR_risk_ode}
\alias{SHLITR_risk_ode}
\title{Susceptible-High-risk-latent-Low-risk-latent-Infected-Treated-Recovered Model, Stratified by Risk}
\usage{
SHLITR_risk_ode(t, x, params)
}
\arguments{
\item{t}{The timestep over which to calculate derivatives}

\item{x}{A numeric vector of compartment populations.}

\item{params}{A named vector of parameter values.}
}
\value{
A vector of derivatives
}
\description{
A more complex SHLIR model flow diagram, with risk groups, treatment, and reinfection for those who have recovered from active disease
}
\examples{

## initialise
inits <- c(
# General population
S = 800,
H = 0,
L = 0,
I = 0,
Tr = 0,
R = 0,
## High risk population
S_H = 199,
H_H = 0,
L_H = 0,
I_H = 1,
Tr_H = 0,
R_H = 0
)

parameters <- c(
beta = 3, # Rate of transmission
beta_H = 6, # High risk rate of transmission
gamma_H = 1/5, # Rate of progression to active symptoms from high risk latent
nu = 1/2, #Rate of progression from high to low risk latent
gamma_L = 1/100, # Rate of progression to active symptoms for low risk latent
epsilon = 1/3, # Rate of treatment
tau = 1/2, # Rate of recovery
M = 0.2 # Between group mixing
)

SHLITR_risk_ode(1, inits, parameters)

}
