% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotIdiograms.R
\name{plotIdiograms}
\alias{plotIdiograms}
\title{Plot idiograms of karyotypes/genomes with and without centromere}
\usage{ plotIdiograms( dfChrSize, defaultFontFamily, revOTUs = FALSE,
 karHeight = 2, karHeiSpace = 2.5, karSepar = TRUE, amoSepar = 10,
 addMissingOTUAfter = NA, addMissingOTUBefore = NA, missOTUspacings = 0,
 moveKarHor = "", moveAllKarValueHor = 0, moveAllKarValueY = 0,
 karAnchorLeft = "", karAnchorRight = "", anchor = FALSE, anchorLineLty = 1,
 anchorText = "", anchorTextMParental, anchorTextMoveX = 0.5,
 anchorTextMoveY = 1, anchorTextMoveParenX = 0, anchorTextMoveParenY = 0,
 anchorVsizeF = 0.5, anchorHsizeF = 1, pchAnchor = 23, moveAnchorV = 0,
 moveAnchorH = 0, mkhValue = 0.5, n = 50, markN = 25, notes, leftNotes,
 leftNotesUp, notesTextSize = 1, leftNotesTextSize = 1, leftNotesUpTextSize = 1,
 notesLeft, notesPosX = 0.5, notesPosY = 0, leftNotesPosX = 0.5,
 leftNotesPosY = 0, leftNotesUpPosX = 0.5, leftNotesUpPosY = 0, noteFont = 1,
 leftNoteFont = 1, leftNoteFontUp = 1, parseTypes = TRUE, parseStr2lang = FALSE,
 propWidth = FALSE, MbThreshold = 10000, threshold = 35, MbUnit = "Mb",
 yTitle = "µm", specialyTitle = "cM", specialOTUNames = "", addOTUName = TRUE,
 OTUTextSize = 1, OTUfont, OTUfamily = "", OTUasNote = FALSE,
 OTUasLeftNote = FALSE, orderChr = "size", chrId = "original",
 classMbName = "Pm.", classcMName = "L.G.", classChrName = "Chr.",
 classChrNameUp = "Type", classGroupName = "", chrNameUp = FALSE,
 chrIdPatternRem, indexIdTextSize = 1, distTextChr = 1, groupUp = FALSE,
 groupName = TRUE, groupSepar = 0.5, chromatids = TRUE, arrowsBothChrt = TRUE,
 holocenNotAsChromatids = FALSE, excHoloFrArrToSide = FALSE, xModifier = 12,
 xModMonoHoloRate = 1, chrWidth = 0.5, chrSpacing = 0.5, specialChrWidth = 0.3,
 specialChrSpacing = 0.7, chrColor = "gray", chrBorderColor, centromereSize = 0,
 autoCenSize = TRUE, cenColor, fixCenBorder = NULL, gishCenBorder = FALSE,
 hideCenLines = 1.75, roundedCen, cenFormat = "rounded", cenFactor = 1,
 squareness = 4, lwd.chr = 0.5, lwd.cM, lwd.marks = 99, dfMarkPos,
 defaultStyleMark = "square", markDistType = "beg", protruding = 0.2,
 startPos = 0, pMarkFac = 0.25, origin = "b", efZero = 1e-05,
 cMBeginCenter = FALSE, arrowhead = 0.3, shrinkArrow = 0.3333,
 arrowheadWidthShrink = 0.1, arrowsToSide = TRUE, useOneDot = FALSE,
 dotsAsOval = FALSE, dfMarkColor, mycolors, alpha_val = 1,
 borderOfWhiteMarks = TRUE, colorBorderMark = "", lwd.mimicCen, defCenStyleCol,
 pattern = "", legend = "aside", remSimiMarkLeg = TRUE, bannedMarkName,
 bMarkNameAside = FALSE, forbiddenMark, legendWidth = 1.7, legendHeight = NA,
 markLabelSize = 1, markLabelSpacer = 1, legendYcoord = 0, markNewLine = NA,
 mylheight = 0.7, chrSize = FALSE, nsmall = 1, chrSizeMbp = FALSE, markPer = "",
 showMarkPos = FALSE, bToRemove = "", perAsFraction = FALSE, chrIndex = "both",
 morpho = "both", nameChrIndexPos = 2, karIndex = TRUE, karIndexPos = 0.5,
 ruler = TRUE, useMinorTicks = FALSE, miniTickFactor = 10, rulerPos = 0,
 ruler.tck = -0.02, rulerNumberPos = 0.5, rulerNumberSize = 1,
 collapseCen = TRUE, rulerInterval = 0, rulerIntervalcM = 0,
 rulerIntervalMb = 0, ceilingFactor = 0, xPosRulerTitle = 2.6,
 yPosRulerTitle = 0, rulerTitleSize = 1, xlimLeftMod = 1, xlimRightMod = 2,
 ylimBotMod = 0.2, ylimTopMod = 0.2, callPlot = TRUE, asp = 1,
 circularPlot = FALSE, verticalPlot = TRUE, karSpaceHor = 0, shrinkFactor = 0.9,
 separFactor = 1.5, labelSpacing = 0.7, labelOutwards = FALSE,
 chrLabelSpacing = 0.5, radius = 0.5, rotation = 0.5, circleCenter = 1,
 circleCenterY = 1, OTUlabelSpacing = 0.3, OTUsrt = 0, OTUplacing = "first",
 OTULabelSpacerx = 0, OTULabelSpacery = 0, OTUcentered = TRUE, OTUjustif = 0,
 OTUlegendHeight = NA, roundness, ... 
)
}
\arguments{
\item{dfChrSize}{mandatory data.frame, with columns: \code{OTU} (optional), \code{chrName} (mandatory),
\code{shortArmSize}, \code{longArmSize} for monocen. or \code{chrSize} for holocen.}

\item{defaultFontFamily}{character. use this as the font family. No default value.}

\item{revOTUs}{boolean, The order of species is the one in the main
data.frame, use \code{TRUE} to reverse}

\item{karHeight}{numeric, vertical size of karyotypes. See also  \code{karHeiSpace}. Defaults to \code{2}}

\item{karHeiSpace}{numeric, vertical size of karyotypes including spacing. Use with \code{karSepar=FALSE}. Proportional to
\code{karHeight}, if overlap, increase. Defautl value \code{2.5}}

\item{karSepar}{boolean, reduce distance among karyotypes \code{FALSE} = equally
sized karyotypes or \code{TRUE} = equally spaced karyotypes. Incompatible with \code{addMissingOTUAfter}}

\item{amoSepar}{numeric, depends on \code{karSepar=TRUE}, if zero your
karyotypes will have no distance among them, if overlap,
increase this and \code{karHeiSpace}}

\item{addMissingOTUAfter}{character, when you want to add space (ghost OTUs) after one or several OTUs, pass the names of OTUs
preceding the desired space in a character vector i.e. \code{c("species one",} \code{} \code{"species five")}}

\item{addMissingOTUBefore}{character, when you want to add space (ghost OTUs) before one or several OTUs, pass the names of OTUs after
the desired space in a character vector i.e. \code{c("species one",} \code{} \code{"species five")}}

\item{missOTUspacings}{numeric, when you use \code{addMissingOTUAfter} this numeric vector should have the same length and corresponds
to the number of free spaces (ghost OTUs) to add after each OTU respectively}

\item{moveKarHor}{character, OTUs' names of karyotypes that should be moved horizontally. See \code{mkhValue}}

\item{moveAllKarValueHor}{numeric, similar to \code{mkhValue}, but affects all karyotypes.}

\item{moveAllKarValueY}{numeric, similar to \code{moveAllKarValueHor}, but affects y axis.}

\item{karAnchorLeft}{character, OTUs' add anchor to the left of this OTU names of karyotypes. For \code{verticalPlot=FALSE}}

\item{karAnchorRight}{character, OTUs' add anchor to the right of this OTU names of karyotypes. For \code{verticalPlot=FALSE}}

\item{anchor}{boolean, when \code{TRUE}, plots a parent progeny structure in karyotypes in \code{moveKarHor}. Or a horizontal anchor
to the left/right
of \code{karAnchorLeft, karAnchorRight} when \code{verticalPlot=FALSE}}

\item{anchorLineLty}{numeric, type of line in \code{anchor}, corresponds to \code{lty}. Defaults to \code{1}}

\item{anchorText}{character, text to add to \code{anchor} structure near symbol. See \code{anchor}. Defaults to \code{""}}

\item{anchorTextMParental}{character, designed to fill with a character object the space left of a missing parental in the
\code{anchor} structure.}

\item{anchorTextMoveX}{numeric, for vertical plots with \code{anchorText} move text in X axis. Defaults to \code{0.5}}

\item{anchorTextMoveY}{numeric, for horizontal plots with \code{anchorText} move text in Y axis. Defaults to \code{1}}

\item{anchorTextMoveParenX}{numeric, for plots with \code{anchorTextMParental} move text in X axis. Defaults to \code{0}}

\item{anchorTextMoveParenY}{numeric, for plots with \code{anchorTextMParental} move text in Y axis. Defaults to \code{0}}

\item{anchorVsizeF}{numeric, factor to modify vertical size of anchor \code{0.5} (default). Size itself is equal to \code{karHeiSpace}}

\item{anchorHsizeF}{numeric, factor to modify horizontal size of anchor \code{1} (default).}

\item{pchAnchor}{numeric, symbol for anchor, see \code{?points} and \code{anchor}}

\item{moveAnchorV}{numeric, displace anchor vertical portion to right or left. See \code{anchor}}

\item{moveAnchorH}{numeric, displace anchor horizontal portion to right or left. See \code{anchor}}

\item{mkhValue}{numeric, value to move kar. hor. See \code{moveKarHor}}

\item{n, }{numeric vertices number for round corners}

\item{markN, }{numeric vertices number for round corners of marks}

\item{notes, }{data.frame, or csv file name in quotes, (shown to the right of kar.), with columns \code{OTU} and \code{note} for adding
notes to each OTU, they appear to the right of chromosomes}

\item{leftNotes, }{data.frame, or csv file name in quotes (shown to the left), with columns \code{OTU} and \code{note} for adding notes
to each OTU, they appear to the left of chromosomes}

\item{leftNotesUp, }{data.frame, or csv file name in quotes, (shown to the left-up), similar to \code{leftNotes}, but intended for
placement over chr.}

\item{notesTextSize}{numeric, font size of notes, see \code{notes}}

\item{leftNotesTextSize}{numeric, font size of notes, see \code{leftNotes}}

\item{leftNotesUpTextSize}{numeric, font size of notes, see \code{leftNotesUp}}

\item{notesLeft}{deprecated, use a data.frame for \code{leftNotes}}

\item{notesPosX}{numeric, move right notes to the right or left (x axis)}

\item{notesPosY}{numeric, move right notes down or up (y axis)}

\item{leftNotesPosX}{numeric, move left notes to the right or left (x axis)}

\item{leftNotesPosY}{numeric, move left notes (\code{leftNotes}) down or up (y axis)}

\item{leftNotesUpPosX}{numeric, move up left notes to the right or left (x axis)}

\item{leftNotesUpPosY}{numeric, move up left notes (\code{leftNotesUp}) down or up (y axis)}

\item{noteFont, }{numeric  \code{1} for normal,  \code{2} for bold,  \code{3} for italics,  \code{4} for bold-italics. See \code{notes}}

\item{leftNoteFont, }{numeric  \code{1} for normal,  \code{2} for bold,  \code{3} for italics,  \code{4} for bold-italics. See
\code{leftNotes}}

\item{leftNoteFontUp, }{numeric  \code{1} for normal,  \code{2} for bold,  \code{3} for italics,  \code{4} for bold-italics. See
\code{leftNotesUp}}

\item{parseTypes, }{boolean, parse in \code{notes} the \emph{Citrus} chr. types names. Creates subindex pos. for FL. Defaults to
\code{TRUE}. Incompatible with \code{parseStr2lang}}

\item{parseStr2lang, }{bolean, parse string in \code{notes} with function \code{str2lang(paste0("paste(",note,")") )} for ex:
\code{"italic('C. sinensis'), ' Author'"}. See \code{notes}, \code{leftNotes},\code{leftNotesUp}.}

\item{propWidth, }{boolean, defaults to \code{FALSE}. Diminishes chr. width with increasing number of OTUs}

\item{MbThreshold, }{numeric, if greater than this number (defaults to \code{10000}), \code{MbUnit} will apply and \code{specialyTitle}
will not.}

\item{threshold, }{this is the max. value allowed for the main two significative digits, otherwise scale will shrink. For example,
after 35 \eqn{\mu m} (Default), apparent size will be 3.5 and scale interval will change. See also \code{ceilingFactor}, you may have to
use \code{-1}. Introduced in 1.13}

\item{MbUnit, }{character, text of units of title when \code{MbThreshold} met and OTU not in \code{specialOTUNames}. See
\code{specialyTitle}
Defaults to \code{"Mb"}, but anything can be used. Introduced in 1.13. See \code{specialyTitle}}

\item{yTitle}{character, units for common title. Defaults to \eqn{\mu m}}

\item{specialyTitle, }{character, title of ruler if OTU is in \code{specialOTUNames}. Will not apply if \code{MbThreshold} met. In that
case use \code{MbUnit}}

\item{specialOTUNames}{character vector, normally title of ruler is micrometer or Mb (big numbers). Use this param. to be able to put
a different unit in ruler title. See \code{"specialyTitle"}}

\item{addOTUName}{boolean, when \code{TRUE} adds OTU (species) name to karyotype}

\item{OTUTextSize}{numeric, font size of OTU name (species). Defaults to \code{1}. When \code{OTUasNote} is \code{TRUE}, use
\code{notesTextSize} instead}

\item{OTUfont}{numeric, \code{1} for normal,  \code{2} for bold,  \code{3} for italics,  \code{4} for bold-italics}

\item{OTUfamily}{character, font family for OTU name.}

\item{OTUasNote}{boolean, when \code{TRUE} adds OTU (species) name to the right, see \code{notes}}

\item{OTUasLeftNote}{boolean, when \code{TRUE} adds OTU (species) name to the left-up, see \code{leftNotesUp}}

\item{orderChr}{character, when \code{"size"}, sorts chromosomes by total
length from the largest to the smallest. \code{"original"}: preserves d.f. order. \code{"name"}: sorts alphabetically;
\code{"group"}: sorts by group name; \code{"chrNameUp"}: sorts according to column \code{chrNameUp}. See \code{chrNameUp}}

\item{chrId}{character, print name of chromosome, \code{"original"} uses the original
name in OTU column of dfChrSize, \code{"simple"} (just 1 to ...) or \code{"none"}.}

\item{classMbName}{character, name of "chromosome" when in Mbp. Defaults to \code{"Pm"}. See \code{MbUnit}}

\item{classcMName}{character, name of "chromosome" when OTU in \code{specialOTUNames}. Defaults to \code{"L.G."}}

\item{classChrName}{character, name of "chromosome" when in micrometers (apparently). Defaults to \code{"Chr."}. See
\code{specialOTUnames}, \code{classMbName}, \code{classcMName}}

\item{classChrNameUp}{character, name of "chromosome" for col. \code{"chrNameUp"}. Defaults to \code{"Type"}}

\item{classGroupName}{character, name of groups. Defaults to \code{""}}

\item{chrNameUp}{boolean, when \code{TRUE} adds secondary chromosome name from col. \code{chrNameUp} over chrs. Defaults to \code{FALSE}}

\item{chrIdPatternRem}{character, regex pattern to remove from chr. names}

\item{indexIdTextSize}{numeric, font size of chr. and kar. indices and
chromosome name. Defaults to \code{1}}

\item{distTextChr}{numeric, distance from name of chromosome to chromosome,
also affects vertical separation of indices. Defaults to \code{1}}

\item{groupUp}{boolean, when \code{TRUE} when groups present, they appear over the chr. name. Defaults to \code{FALSE}}

\item{groupName}{boolean, when \code{TRUE} (default), shows group names. When \code{FALSE} only line}

\item{groupSepar}{numeric, factor for affecting chr. spacing \code{chrSpacing} among groups. Defaults to \code{0.5}}

\item{chromatids}{boolean, when \code{TRUE} shows separated chromatids. Defaults to \code{TRUE}}

\item{arrowsBothChrt}{boolean, when \code{TRUE} (default) (for \code{chromatids=TRUE}) shows \code{upArrow,} \code{} \code{ downArrow}
styles of marks in both chromatids when \code{arrowsToSide=TRUE}.}

\item{holocenNotAsChromatids}{boolean, when \code{TRUE} and \code{chromatids=TRUE} does not plot holocen kar. with chromatids.
Defaults to \code{FALSE}.}

\item{excHoloFrArrToSide}{boolean, when \code{arrowsToSide=TRUE}, excludes holocen. from this behaviour, plotting a centered arrow only.}

\item{xModifier}{numeric, for \code{chromatids=TRUE}, separation among chromatids. Quotient for \code{chrWidth}. Defaults to \code{12
: chrWidth/12}}

\item{xModMonoHoloRate}{numeric, factor to shrink chromatid separ. for holocen. 5 means 5 times smaller (quotient).}

\item{chrWidth}{numeric, relative chromosome width. Defaults to \code{0.5}}

\item{chrSpacing}{numeric, horizontal spacing among chromosomes, see also  \code{chrWidth}. Defaults to \code{0.5}}

\item{specialChrWidth}{numeric, relative chromosome width. Defaults to \code{0.5} for OTUs in \code{specialOTUNames}}

\item{specialChrSpacing}{numeric, horizontal spacing among chromosomes for OTUs in \code{specialOTUNames}, see also  \code{chrWidth}.
Defaults to \code{0.5}}

\item{chrColor}{character, main color for chromosomes. Defaults to \code{"gray"}}

\item{chrBorderColor}{character, color for border of chromosomes, defaults to \code{chrColor}}

\item{centromereSize}{numeric, optional, this establishes the apparent size of cen. in the plot in \eqn{\mu}m. See
\code{autoCenSize=TRUE}. Default: \code{0}. Use with \code{autoCenSize=FALSE}}

\item{autoCenSize}{boolean, when \code{TRUE} ignores \code{centromereSize}}

\item{cenColor}{character, color for centromeres, if GISH use \code{NULL} or \code{NA}. Defaults to \code{chrColor}}

\item{fixCenBorder}{boolean, when \code{TRUE} uses \code{chrColor} as centromere (and cen. mark) border color. See also \code{cenColor},
\code{chrColor}, \code{colorBorderMark}, \code{borderOfWhiteMarks}. No default value. When \code{chrColor} is \code{"white"} this
turns into \code{"black"}.}

\item{gishCenBorder}{boolean, when \code{TRUE}, cen. mark border color is the same as mark color, ignoring \code{colorBorderMark}. No
default.}

\item{hideCenLines}{numeric, factor to multiply line width (lwd) used for covering cen. border, when \code{chrColor} is \code{white}
or when \code{gishCenBorder=TRUE}}

\item{roundedCen}{deprecated, see cenFormat}

\item{cenFormat}{boolean, when \code{"triangle"}, cen. has triangular aspect. When \code{"rounded"}, it has rounded aspect (Default).
\code{"inProtein"} for using the mark with style of same name.}

\item{cenFactor}{numeric, modifies any cen. mark and cen. size. Defaults to \code{1}}

\item{squareness}{numeric, shape of vertices of chromosomes and square marks,
higher values more squared. Defaults to \code{4}}

\item{lwd.chr}{thickness of border of chr., some marks and ruler. Thick of \code{cM} marks when \code{lwd.cM} absent and other marks
when \code{lwd.marks} absent. Defaults to \code{0.5}}

\item{lwd.cM}{thickness of cM marks. Defaults to \code{lwd.chr}}

\item{lwd.marks}{thickness of most marks. Except \code{cM} marks and centr. related marks. See \code{lwd.chr}, \code{lwd.cM}. Defaults
to \code{lwd.chr} value when \code{99}}

\item{dfMarkPos}{data.frame of marks (sites): columns: \code{OTU} (opt), \code{chrName},
\code{markName} (name of site), \code{chrRegion} (for monocen. and opt for whole arm (w) in holocen.), \code{markDistCen} (for
monocen.),
\code{markPos} (for holocen.), \code{markSize}; column \code{chrRegion}:
use \code{p} for short arm, \code{q} for long arm, \code{cen} for centromeric mark and \code{w} for whole chr. mark; column
\code{markDistCen}: use distance from
centromere to mark, not necessary for cen. marks (cen), w, p, q (when whole arm). See also param. \code{markDistType}}

\item{defaultStyleMark}{character, default style of mark, only used when \code{style} column of \code{dfMarkColor} data.frame is
missing or in absence of this data.frame. Use \code{"square"} (default), \code{"squareLeft"}, \code{"dots"}, \code{"cM"},
\code{"cMLeft"},\code{"cenStyle"}, \code{"upArrow"}, \code{"downArrow"}.}

\item{markDistType}{character, if \code{"cen"} = the distance you provided in data.frame (\code{dfMarkPos}) column \code{markDistCen}
or \code{markPos}  is to the center of the mark, if \code{"beg"} = the distance you provided is to the
beginning of the mark (Default)}

\item{protruding}{numeric, when style of mark is \code{"cM"}, fraction of chrWidth to stretch marker. Defaults to \code{0.2}.
Introduced in 1.13}

\item{startPos}{numeric, factor to increase separation of \code{exProtein} marks to chromosome. Defaults to \code{0}}

\item{pMarkFac}{numeric, fraction of chr. size for \code{exProtein} style marks. Defaults to \code{0.25}}

\item{origin, }{For non-monocentric chr. (for holocentrics only) Use \code{"b"} (default) if distance to mark in (\code{"markPos"}
column in \code{"dfMarkPos"}) data.frame measured from bottom of chromosome, use \code{"t"} for distance to mark from top of chr.}

\item{efZero, }{numeric, numbers below this one will be considered as zero, for comparison purposes. Defaults to \code{1e-5}}

\item{cMBeginCenter, }{boolean, start position of \code{cM} and \code{cMLeft} marks. If \code{TRUE}, starts in the center (width) of
chr. . Defaults to \code{FALSE}}

\item{arrowhead}{numeric, proportion of head of arrow (mark styles: \code{upArrow,} \code{} \code{downArrow}). Defaults to \code{0.3}}

\item{shrinkArrow}{numeric, proportion, shrinks body of arrow. Defaults to \code{0.3333}}

\item{arrowheadWidthShrink}{numeric, proportion, shrinks head of arrow. Defaults to \code{0.1}}

\item{arrowsToSide}{boolean, when \code{FALSE} use a centered arrow, instead of an arrow next to chr. margins (\code{TRUE}, default).
See \code{arrowsBothChrt}}

\item{useOneDot}{boolean, use one dot instead of two in style of marks \code{dots}. Defaults to \code{FALSE}. Not useful for
\code{chromatids=TRUE}}

\item{dotsAsOval}{boolean, use oval instead of two dots in style of marks \code{dots}. Defaults to \code{FALSE}. See \code{useOneDot}.
Not useful for \code{chromatids=TRUE} or \code{circularPlot=TRUE}}

\item{dfMarkColor}{data.frame, optional, specifying colors and style for marks (sites);
columns: \code{markName}, \code{markColor}, \code{style}. \code{style} accepts: \code{square}, \code{squareLeft}, \code{dots},
\code{cM},
\code{"cMLeft"}, \code{"cenStyle"}, \code{"upArrow"}, \code{"downArrow"}, \code{"exProtein"}.
(if column \code{style} missing all (except 5S) are plotted as in param. \code{defaultStyleMark}).}

\item{mycolors}{character vector, optional, i.e. \code{c("blue",} \code{"red",} \code{"green")} for specifying color of marks in order
of appearance. if diverges with number of marks will be recycled if \code{dfMarkColor} present, mycolors will be ignored. To know the
order of your marks use something like: \code{unique(dfMarkPos$markName)}}

\item{alpha_val}{numeric vector, make marks transparent, accepts values from 0 to 1, @see \code{scales::alpha}}

\item{borderOfWhiteMarks}{boolean, if \code{TRUE} (Default) uses black border for white marks. See \code{dfMarkColor}. Does not apply
to marks with style \code{cenStyle}}

\item{colorBorderMark}{character, without default, pass a name of a color to use as border of marks. See \code{borderOfWhiteMarks}}

\item{lwd.mimicCen}{thickness of lines of \code{cenStyle} marks; affects only lateral borders. Defaults to \code{lwd.chr}}

\item{defCenStyleCol}{character, color of outer part of \code{cenStyle} marks. Defaults to \code{white}}

\item{pattern}{REGEX pattern to remove from names of marks}

\item{legend}{character, \code{"none"} for no legend; \code{"inline"} prints labels near
chromosomes; \code{"aside"} prints legend to the right of karyotypes (default). See \code{markLabelSpacer}}

\item{remSimiMarkLeg}{boolean, when \code{legend="aside"}, if you use \code{pattern}, you can have several marks with same name. When
\code{TRUE} this remove this pseudoduplicates from legend. Be sure that this pseudoduplicates have the same color, otherwise you should
use \code{FALSE}.}

\item{bannedMarkName}{character, character string or vector with mark names to be removed from plot. Not the marks but the labels.
Except when \code{bMarkNameAside} is used.}

\item{bMarkNameAside}{boolean, when \code{TRUE} and \code{legend="inline"}, shows marks in \code{bannedMarkName} as
\code{legend="aside"}.}

\item{forbiddenMark, }{character, character string or vector with mark names to be removed from plot. Not the marks but the labels.}

\item{legendWidth}{numeric, factor to increase width of squares and of legend. Defaults to \code{1.7}}

\item{legendHeight}{numeric, factor to increase height of squares and dots of legend. Automatic.}

\item{markLabelSize}{numeric, only if legend != (not) "", size of the font of
labels of marks (legend). Defaults to \code{1}}

\item{markLabelSpacer}{numeric, only if \code{legend="aside"}, space from the
rightmost chr. to legend. Defaults to \code{1}}

\item{legendYcoord}{numeric, modify Y position of legend when \code{legend="aside"}}

\item{markNewLine, }{character, character to split mark Names into different lines. Applies to \code{square} marks. Defaults to \code{NA}}

\item{mylheight, }{numeric, for \code{markNewLine!=NA}; is equivalent to \code{lheight} of \code{par}: "The line height multiplier. The
height of a line of text (used to vertically space multi-line text) is found by multiplying the character height both by the current
character expansion and by the line height multiplier." Defaults to \code{0.7}.}

\item{chrSize}{boolean, when \code{TRUE} adds total chr size under each chr. Defaults to \code{FALSE}}

\item{nsmall}{numeric, rounding decimals for \code{chrSize} parameter. Defaults to \code{1}}

\item{chrSizeMbp}{boolean, when \code{TRUE} adds total Mbp chr. size to each chr. provided, there is a \code{Mbp} column in
\code{dfChrSize} data.frame. Defaults to \code{FALSE}. If data in columns \code{shortArmSize}, or col. \code{chrSize} is in millions
("Mbp"). Use \code{chrSize=TRUE} not this one (not column \code{Mbp}, you don't need this).}

\item{markPer}{character vector, name of mark(s) to calculate \% of mark in chr. and add it to plot. See \code{perAsFraction}}

\item{showMarkPos}{boolean, adds position of marks under karyotype (fraction 0-1) when \code{TRUE}. Defaults to \code{FALSE}}

\item{bToRemove, }{character vector, bands to remove from calc. of pos., when \code{showMarkPos = TRUE}}

\item{perAsFraction}{boolean, when \code{TRUE} \% is shown as fraction. Defaults to \code{FALSE}. See \code{markPer}}

\item{chrIndex}{character, add arm ratio with \code{"AR"} and centromeric index with \code{"CI"}, or \code{"both"} (Default), or
\code{"none"} for none}

\item{morpho}{character, when \code{"both"} (default) prints the Guerra and Levan classif of cen. position, use also \code{"Guerra"}
or  \code{"Levan"} or \code{"none"} for none. See also \code{?armRatioCI}.}

\item{nameChrIndexPos}{numeric, modify position of name of chr. indices}

\item{karIndex}{logical, add karyotype indices A (intrachromosomal -
centromere pos.) and A2 (interchromosomal asymmetry, variation among
chromosome sizes)}

\item{karIndexPos}{numeric, move karyotype index. Defaults to \code{0.5}}

\item{ruler}{boolean, display ruler to the left of karyotype, when \code{FALSE} no ruler}

\item{useMinorTicks}{boolean, display minor ticks between labeled ticks in ruler. See \code{miniTickFactor}. Defaults to \code{FALSE}.
(ticks without label)}

\item{miniTickFactor}{numeric, number of minor ticks for each labeled tick. See \code{useMinorTicks}. Defaults to \code{10}}

\item{rulerPos}{numeric, absolute position of ruler, corresponds to \code{pos}
argument of \code{axis} R plot}

\item{ruler.tck}{numeric, tick size of ruler, corresponds to \code{tck} argument of
\code{axis} R plot. Defaults to \code{-0.02}}

\item{rulerNumberPos}{numeric, modify position of numbers of ruler. Defaults to \code{0.5}}

\item{rulerNumberSize}{numeric, size of number's font in ruler. Defaults to \code{1}}

\item{collapseCen}{boolean, avoid spacing in ruler between short arm and long arm.}

\item{rulerInterval}{numeric, intervals in ruler. No default, automatic.}

\item{rulerIntervalcM}{numeric, intervals in ruler of OTU in \code{specialOTUNames}. No default. Introduced in 1.13}

\item{rulerIntervalMb}{numeric, intervals in ruler of OTU with data in Mb (>\code{MbThreshold}) and absent from
\code{specialOTUNames}. No default. Usa data in millions}

\item{ceilingFactor}{numeric, affects number of decimals for ceiling. Affects max. value of ruler. Defaults to \code{0}. When
\code{threshold} is greater than \code{35} this may have to be negative. Introduced in 1.13}

\item{xPosRulerTitle, }{numeric, modify position of ruler title. See \code{yTitle,} \code{} \code{ specialyTitle,} \code{} \code{
MbUnit}. Defaults to \code{2.6}. A value of \code{2.6} means \code{2.6} times the value of \code{chrSpacing} to the left, from the first
chr.}

\item{yPosRulerTitle, }{numeric, affects vertical position of ruler title. Defaults to \code{0}}

\item{rulerTitleSize, }{numeric font size of units of ruler. See also \code{xPosRulerTitle}}

\item{xlimLeftMod}{numeric, modifies \code{xlim} left argument of plot}

\item{xlimRightMod}{numeric, \code{xlim} right side modification by adding space to the right
of idiograms. Defaults to \code{2}}

\item{ylimBotMod}{numeric, modify \code{ylim} bottom argument of plot}

\item{ylimTopMod}{numeric, modify \code{ylim} top argument of plot}

\item{callPlot}{boolean, create new plot in your device. Defaults to \code{TRUE}}

\item{asp, }{numeric, y x aspect of plot. Defaults to \code{1}}

\item{circularPlot}{boolean, if \code{TRUE} chromosomes/karyotypes are plotted in concentric circles. Defaults to \code{FALSE}}

\item{verticalPlot}{boolean, when \code{TRUE} karyotypes are plotted vertically, otherwise, horizontally Defaults to \code{TRUE}}

\item{karSpaceHor}{numeric, separation among horizontal karyotypes. When \code{verticalPlot=FALSE}. Defaults to \code{0}}

\item{shrinkFactor}{numeric, for \code{circularPlot=TRUE} percentage of usage of circle. Defaults to \code{0.9}}

\item{separFactor}{numeric, for \code{circularPlot=TRUE} modify separation of concentric karyotypes. Defaults to \code{1.5}}

\item{labelSpacing}{numeric, for \code{circularPlot=TRUE}. Spacing of mark labels. Defaults to \code{0.7}}

\item{labelOutwards}{boolean, inline labels projected outwards}

\item{chrLabelSpacing}{numeric, for \code{circularPlot=TRUE}. Spacing of chr. labels. Defaults to \code{0.5}}

\item{radius}{numeric, for \code{circularPlot=TRUE}. Affects radius of karyotypes. Defaults to \code{0.5}}

\item{rotation}{numeric, anti-clockwise rotation, defaults to \code{0.5} which rotates chr. from top to -90 degrees. (-0.5*\eqn{\pi} )}

\item{circleCenter}{numeric, for \code{circularPlot=TRUE}. Coordinate X of center of circles. Affects \code{legend="aside"} position.
Defaults to \code{1}}

\item{circleCenterY}{numeric, for \code{circularPlot=TRUE}. Coordinate Y of center of circles. Affects \code{legend="aside"} position.
Defaults to \code{1}}

\item{OTUlabelSpacing}{numeric, for \code{circularPlot=TRUE}. Spacing for OTU names. Defaults to \code{0.3}}

\item{OTUsrt}{numeric, for \code{circularPlot=TRUE}. Angle to use for OTU names. Defaults to \code{0}}

\item{OTUplacing}{character, for \code{circularPlot=TRUE}. location of OTU name. Defaults to \code{"first"} plots name near
first chr. \code{"number"} places number near 1st chr. and index and name to the right or center.
\code{"simple"} place name to the right or center without numbering. See also \code{OTUcentered}}

\item{OTULabelSpacerx}{numeric, for \code{circularPlot=TRUE} and \code{OTUplacing="number" or "simple"}. Modifies x names position}

\item{OTULabelSpacery}{numeric, for \code{circularPlot=TRUE} and \code{OTUplacing="number" or "simple"}. Modifies y names position}

\item{OTUcentered}{boolean, for \code{circularPlot=TRUE} and \code{OTUplacing="number" or "simple"}. OTU name in center of circle
when \code{TRUE}, otherwise, to the right.}

\item{OTUjustif}{numeric, for \code{circularPlot=TRUE} and \code{OTUplacing="number" or "simple"}. Justification of OTU name. \code{0}
= left
(Default); use \code{0.5} for centered. See \code{?text} -> \code{adj}}

\item{OTUlegendHeight}{numeric, for \code{circularPlot=TRUE} and \code{OTUplacing="number" or "simple"}. Modifies y names separation}

\item{roundness}{deprecated, use \code{squareness}}

\item{...}{accepts other arguments for the plot, see, \code{?plot}}
}
\value{
plot
}
\description{
This function reads a data.frame passed to \code{dfChrSize} with columns: \code{chrName} (mono/holo) and
\code{shortArmSize} and \code{longArmSize} for monocentrics or a column \code{chrSize} for holocentrics and produces a plot of
idiograms. If more
than one species, a column named \code{OTU} is needed.

Optionally, it reads another data.frame passed to \code{dfMarkPos} with the position of
marks (sites). Examples: \code{\link{markposDFs}}. Another data.frame for mark characteristics
can be used \code{\link{dfMarkColor}} or a character vector passed to \code{mycolors}
}
\examples{
data(dfOfChrSize)
plotIdiograms(dfOfChrSize, ylimBotMod = .75, rulerPos = -.5)
plotIdiograms(dfOfChrSize, circularPlot = TRUE, chrLabelSpacing = 1)
plotIdiograms(dfChrSizeHolo, rulerPos = -.5)
}
\seealso{
\code{\link{asymmetry}}

\code{\link{armRatioCI}}

\code{\link{chrbasicdatamono}}

\code{\link{chrbasicdataHolo}}

\code{\link{markposDFs}}

\code{\link{markdataholo}}

\code{\link{dfMarkColor}}
}
\keyword{chromosome}
\keyword{data.frame}
