% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idem_imputation.R
\name{plot.IDEMSINGLE}
\alias{plot.IDEMSINGLE}
\title{Plot MCMC mixing results}
\usage{
\method{plot}{IDEMSINGLE}(x, ...)
}
\arguments{
\item{x}{A class \code{IDEMSINGLE} object returned from \code{\link{imImpSingle}}}

\item{...}{Additional arguments}
}
\description{
Plot method of the class \code{IDEMSINGLE} to generate traceplot of the imputed missing
outcomes
}
\examples{
im.abc <- imData(abc, trt="TRT", surv="SURV", outcome=c("Y1","Y2"),
                 y0=NULL, endfml="Y2",
                 trt.label = c("UC+SBT", "SAT+SBT"),
                 cov=c("AGE"), duration=365, bounds=c(0,100));
im.fit <- imFitModel(im.abc);
im.imp.single <- imImpSingle(abc[1,], im.fit,
                             chains = 4, iter = 200, warmup = 100);
plot(im.imp.single);

}
\seealso{
\code{\link{imImpSingle}}
}
