% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idem_imputation.R
\name{imNeedImp}
\alias{imNeedImp}
\title{Get subjects that need imputation}
\usage{
imNeedImp(data.all, lst.var, endponly = TRUE)
}
\arguments{
\item{data.all}{Original dataset}

\item{lst.var}{see \code{\link{idem-parameters}}}

\item{endponly}{Logical variable indicating whether clinical outcomes not
used in calculating the final clinical outcome will be imputed. The
default is FALSE, indicating that all missing clinical outcomes will be
imputed sequentially}
}
\value{
Vector of indices of subjects that need imputation
}
\description{
Get the index of subjects in a dataset that need imputation, i.e. survivors with
functional endpoint missing
}
\examples{

lst.var <- list(trt="TRT", surv="SURV", outcome=c("Y1","Y2"), y0=NULL,
                endp=c("Y2"), unitTime="days",
                trt.label = c("UC+SBT", "SAT+SBT"),
                cov=c("AGE"), endfml="Y2", duration=365, bounds=c(0,100));
inx.imp <- imNeedImp(abc, lst.var);

}
