% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grids.r
\docType{methods}
\name{lines3d,trigrid-method}
\alias{lines3d,trigrid-method}
\alias{lines3d-trigrid-method}
\title{Methods of 3d line plotting.}
\usage{
\S4method{lines3d}{trigrid}(x, arcs = FALSE, ...)
}
\arguments{
\item{x}{The \code{trigrid}, \code{hexagrid}, \code{facelayer} or \code{sp} object to be plotted.}

\item{arcs}{Logical value setting whether great circle arcs or segments shall be drawn betwenn the points of the grid.}

\item{...}{Further graphical parameters passed to (see \code{\link[rgl]{plot3d}}).}
}
\value{
The function does not return any value.
}
\description{
This is a generic function used to plot the edge lines of either a \code{trigrid} or a \code{hexagrid} object in 3d space. The method is also implemented for 
the object classes defined by the package 'sp'.
}
\details{
The function is built on the openGL renderer of the R package \code{rgl}.
}
\examples{
# create a hexagonal grid
    g <- hexagrid(c(2,2))
# plot the grid in 3d space
    plot3d(g, col="blue")
# make a subset to select faces
   subG <- subset(g, c("F5", "F2"))
# plot the subset defined above
    plot3d(subG, type="f", col=c("orange"), add=TRUE, lwd=1)
}

