% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strat.R
\name{strat}
\alias{strat}
\title{Create Ichimoku Strategies}
\usage{
strat(
  x,
  c1 = c("close", "chikou", "open", "high", "low", "tenkan", "kijun", "senkouA",
    "senkouB", "cloudT", "cloudB"),
  c2 = c("tenkan", "kijun", "senkouA", "senkouB", "cloudT", "cloudB", "chikou", "close",
    "open", "high", "low"),
  c3 = c("close", "chikou", "open", "high", "low", "tenkan", "kijun", "senkouA",
    "senkouB", "cloudT", "cloudB"),
  c4 = c("tenkan", "kijun", "senkouA", "senkouB", "cloudT", "cloudB", "chikou", "close",
    "open", "high", "low"),
  dir = c("long", "short"),
  type = 2
)
}
\arguments{
\item{x}{an ichimoku object.}

\item{c1}{[default 'close'] column name specified as a string.}

\item{c2}{[default 'tenkan'] column name specified as a string.}

\item{c3}{(optional) column name specified as a string.}

\item{c4}{(optional) column name specified as a string.}

\item{dir}{[default 'long'] trade direction, either 'long' or 'short'.}

\item{type}{[default 2] if 'c3' and 'c4' are specified, type 2 will create the
combined strategy 'c1 > c2 & c3 > c4' whilst type 3 will create the
asymmetric strategy 'c1 > c2 x c3 > c4'.}
}
\value{
An ichimoku object augmented with the strategy.
}
\description{
Create ichimoku cloud strategies using the indicator condition 'long / short
    while c1 > c2'. Complex strategies can be formulated as combined
    'c1 > c2 & c3 > c4' (both conditions must be satisfied) or asymmetric
    'c1 > c2 x c3 > c4' (where 'c1 > c2' denotes the entry and 'c3 > c4' the
    exit indicator).
}
\details{
The following assumption applies to all strategies: confirmation of
    whether a condition is satisfied is received at the 'close' of a particular
    period, and a transaction is initiated at the immediately following 'open'.
    All transactions occur at the 'open'.

    By default, the periods in which the strategy results in a position is
    shaded on the ichimoku cloud chart and the strategy is printed as the
    chart message (if not otherwise specified). To turn off this behaviour,
    pass the \code{strat = FALSE} argument to plot() or iplot().
}
\section{Ichimoku Object Specification for Strategies}{


    The ichimoku object is augmented with the following additional elements:

    Columns [numeric]:
    \itemize{
        \item{\code{$cond}:} {a boolean vector if the indicator condition is met}
        \item{\code{$posn}:} {a boolean vector indicating if a position is held}
        \item{\code{$txn}:} {a vector representing the transactions to implement
        the position (1 = enter position, -1 = exit position)}
        \item{\code{$logret}:} {a vector of log returns}
        \item{\code{$slogret}:} {a vector of log returns for the strategy}
        \item{\code{$ret}:} {a vector of discrete returns}
        \item{\code{$sret}:} {a vector of of discrete returns for the strategy}
     }

    Attributes:
    \itemize{
        \item{\code{$strat}:} {the strategy summary [matrix]}
     }

    The strategy summary may be accessed by the \code{summary()} method for
    ichimoku objects or via \code{\link{look}}.
}

\section{Complex Strategies}{

    For complex strategies: 's1' denotes the strategy 'c1 > c2' and 's2'
    denotes the strategy 'c3 > c4'.

    \itemize{
        \item{Combined strategy 's1 & s2':} {indicator conditions in 's1' and
        's2' have to be met simulateneously for a position to be taken. The
        column \code{$cond} will show when both conditions are met.}
        \item{Asymmetric strategy 's1 x s2':} {indicator condition in 's1' has
        to be met to enter a position, and indicator condition in 's2' to exit
        a position. These rules are applied recursively over the length of the
        data. The column \code{$cond} will show when the indicator condition
        is met in 's1'}
     }
}

\section{Further Details}{

    Please refer to the strategies vignette by calling:
    \code{vignette("strategies", package = "ichimoku")}
}

\examples{
cloud <- ichimoku(sample_ohlc_data, ticker = "TKR")

strat <- strat(cloud, c1 = "tenkan", c2 = "cloudB", dir = "short")
summary(strat)
plot(strat)

strat2 <- strat(cloud, c1 = "cloudT", c2 = "kijun", c3 = "cloudT", c4 = "close")
summary(strat2)
plot(strat2)

}
