% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ichimoku.R
\name{autoplot}
\alias{autoplot}
\alias{autoplot.ichimoku}
\title{autoplot.ichimoku}
\usage{
\method{autoplot}{ichimoku}(
  object,
  window,
  ticker,
  message,
  theme = c("original", "dark", "solarized", "mono"),
  strat = TRUE,
  ...
)
}
\arguments{
\item{object}{an object of class 'ichimoku'.}

\item{window}{(optional) a date-time window to subset the plot, in ISO-8601
compatible range strings of the format used for 'xts' objects, for example
"2020-02-15/2020-08-15" or "2020-02-15/", "/2020-08" or "2020-07".}

\item{ticker}{(optional) specify a ticker (or other text) to include in the
chart heading. If not set, the ticker saved within the ichimoku object
will be used.}

\item{message}{(optional) specify a chart message to display under the title.}

\item{theme}{[default 'original'] with alternative choices of 'dark',
'solarized' or 'mono'.}

\item{strat}{[default TRUE] if the ichimoku object contains a strategy, the
periods for which the strategy results in a position will be shaded, and
the strategy printed as the chart message (if a message is not already
specified). Set to FALSE to turn off this behaviour.}

\item{...}{other arguments not used by this method.}
}
\value{
Returns a ggplot2 object with S3 classes 'gg' and 'ggplot'.
}
\description{
Plot static Ichimoku Kinko Hyo cloud charts from ichimoku objects.
}
\details{
This function is an S3 method for the generic function autoplot()
    for class 'ichimoku'. It can be invoked by calling autoplot(x) on an
    object 'x' of class 'ichimoku'.
}
\section{Further Details}{

    Please refer to the reference vignette by running:
    \code{vignette("reference", package = "ichimoku")}
}

\examples{
cloud <- ichimoku(sample_ohlc_data, ticker = "TKR")

autoplot(cloud)
autoplot(cloud, window = "2020-05-15/2020-10-30", theme = "dark")
autoplot(cloud, ticker = "TKR Co.", theme = "solarized")

}
