% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ichimoku.R
\name{plot.ichimoku}
\alias{plot.ichimoku}
\title{Plot Ichimoku Cloud Chart}
\usage{
\method{plot}{ichimoku}(
  x,
  window,
  ticker,
  theme = c("original", "dark", "solarized", "mono"),
  gaps = FALSE,
  strat = TRUE,
  ...
)
}
\arguments{
\item{x}{an object of class 'ichimoku'.}

\item{window}{(optional) a date-time window to subset the plot, in ISO-8601
compatible range strings of the format used for 'xts' objects, for example
"2020-02-15/2020-08-15" or "2020-02-15/", "/2020-08" or "2020-07".}

\item{ticker}{(optional) specify a ticker (or other text) to include in the
chart heading. If not set, the ticker saved within the ichimoku object
will be used.}

\item{theme}{defaults to 'original'. This can also be set to 'dark',
'solarized' or 'mono'.}

\item{gaps}{defaults to FALSE to remove weekend and holiday gaps. Set to TRUE
for a continuous timescale axis, but with gaps for non-trading days.}

\item{strat}{set to TRUE by default. If the ichimoku object contains a
strategy, the periods for which the strategy results in a position will
be shaded. Set to FALSE to turn off this behaviour.}

\item{...}{other arguments to be passed along.}
}
\value{
Returns a ggplot2 object with classes 'gg' and 'ggplot'.
}
\description{
Plot Ichimoku Kinko Hyo cloud charts from ichimoku objects.
}
\details{
This function is an S3 method for the generic function plot() for
    class 'ichimoku'. It can be invoked by calling plot(x) on an object 'x'
    of class 'ichimoku'.
}
\section{Further Details}{

    Please refer to the reference vignette by running:
    \code{vignette("reference", package = "ichimoku")}
}

\examples{
cloud <- ichimoku(sample_ohlc_data, ticker = "TKR")

plot(cloud)
plot(cloud, window = "2020-05-15/2020-10-30", theme = "mono")

}
