% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deps.R
\name{deps}
\alias{deps}
\title{List Dependencies}
\usage{
deps(path = ".", base = FALSE, installed = TRUE, available = TRUE,
  list = FALSE)
}
\arguments{
\item{path}{a directory or file containing R scripts.}

\item{base}{whether to include base packages in the output.}

\item{installed}{whether to include installed packages in the output.}

\item{available}{whether to include available packages in the output.}

\item{list}{whether to return packages in list format.}
}
\value{
Names of packages as a vector, or in list format if \code{list=TRUE}. If no
dependencies are found, the return value is \code{NULL}.
}
\description{
Search R scripts for packages that are required.
}
\note{
Package names are matched based on four patterns:\preformatted{
library(*)
require(*)
*::object
*:::object}

The search algorithm may return false-positive dependencies if these patterns
occur inside if-clauses, strings, comments, etc.
}
\examples{
dir <- system.file(package="MASS", "scripts")
script <- system.file(package="MASS", "scripts/ch08.R")

deps(script)                   # dependencies
deps(script, base=TRUE)        # including base packages
deps(script, installed=FALSE)  # not (yet) installed

deps(dir)
deps(dir, list=TRUE)

\dontrun{
deps(dir, available=FALSE)  # dependencies that might be unavailable
}

}
\seealso{
\code{\link{installed.packages}}, \code{\link{available.packages}}.

\code{\link{icesTAF-package}} gives an overview of the package.
}
