# This file was generated by Rcpp::compileAttributes
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @rdname icd9Comorbid
#' @description RcppParallel approach with openmp and vector of integer strategy
#' @param aggregate single logical value, if /code{TRUE}, then take (possible much) more time to aggregate out-of-sequence visit IDs in the icd9df data.frame. If this is \code{FALSE}, then each contiguous group of visit IDs will result in a row of comorbidities in the output data. If you know your visitIds are possible disordered, then use \code{TRUE}.
#' @keywords internal
icd9ComorbidShortCpp <- function(icd9df, icd9Mapping, visitId = "visitId", icd9Field = "icd9", threads = 8L, chunkSize = 256L, ompChunkSize = 1L, aggregate = TRUE) {
    .Call('icd9_icd9ComorbidShortCpp', PACKAGE = 'icd9', icd9df, icd9Mapping, visitId, icd9Field, threads, chunkSize, ompChunkSize, aggregate)
}

icd9MajMinToCodeShim <- function(mjr, mnr, isShort) {
    .Call('icd9_icd9MajMinToCodeShim', PACKAGE = 'icd9', mjr, mnr, isShort)
}

icd9MajMinToShortShim <- function(mjr, mnr) {
    .Call('icd9_icd9MajMinToShortShim', PACKAGE = 'icd9', mjr, mnr)
}

icd9MajMinToDecimalShim <- function(mjr, mnr) {
    .Call('icd9_icd9MajMinToDecimalShim', PACKAGE = 'icd9', mjr, mnr)
}

#' @rdname convert
#' @export
icd9PartsToShort <- function(parts) {
    .Call('icd9_icd9PartsToShort', PACKAGE = 'icd9', parts)
}

#' @rdname convert
#' @export
icd9PartsToDecimal <- function(parts) {
    .Call('icd9_icd9PartsToDecimal', PACKAGE = 'icd9', parts)
}

icd9MajMinToPartsShim <- function(mjr, mnr) {
    .Call('icd9_icd9MajMinToPartsShim', PACKAGE = 'icd9', mjr, mnr)
}

icd9MajMinToParts_listShim <- function(mjr, mnr) {
    .Call('icd9_icd9MajMinToParts_listShim', PACKAGE = 'icd9', mjr, mnr)
}

#' @rdname convert
#' @export
icd9ShortToParts <- function(icd9Short, minorEmpty = "") {
    .Call('icd9_icd9ShortToParts', PACKAGE = 'icd9', icd9Short, minorEmpty)
}

#' @rdname convert
#' @export
icd9DecimalToParts <- function(icd9Decimal, minorEmpty = "") {
    .Call('icd9_icd9DecimalToParts', PACKAGE = 'icd9', icd9Decimal, minorEmpty)
}

#' @rdname convert
#' @export
icd9ShortToDecimal <- function(icd9Short) {
    .Call('icd9_icd9ShortToDecimal', PACKAGE = 'icd9', icd9Short)
}

#' @rdname convert
#' @export
icd9DecimalToShort <- function(icd9Decimal) {
    .Call('icd9_icd9DecimalToShort', PACKAGE = 'icd9', icd9Decimal)
}

#' @rdname convert
#' @export
icd9GetMajor <- function(icd9, isShort) {
    .Call('icd9_icd9GetMajor', PACKAGE = 'icd9', icd9, isShort)
}

#' @name icd9Is
#' @title are the given codes numeric, V or E type?
#' @description Quickly find V or E codes, without any validation.
#' @template icd9-any
#' @export
icd9IsV <- function(icd9) {
    .Call('icd9_icd9IsV', PACKAGE = 'icd9', icd9)
}

#' @rdname icd9Is
#' @export
icd9IsE <- function(icd9) {
    .Call('icd9_icd9IsE', PACKAGE = 'icd9', icd9)
}

#' @rdname icd9Is
#' @export
icd9IsN <- function(icd9) {
    .Call('icd9_icd9IsN', PACKAGE = 'icd9', icd9)
}

icd9LongToWideCpp <- function(icd9df, visitId = "visitId", icd9Field = "icd9", aggregate = TRUE) {
    .Call('icd9_icd9LongToWideCpp', PACKAGE = 'icd9', icd9df, visitId, icd9Field, aggregate)
}

icd9AddLeadingZeroesMajorSingleShim <- function(mjr) {
    .Call('icd9_icd9AddLeadingZeroesMajorSingleShim', PACKAGE = 'icd9', mjr)
}

icd9AddLeadingZeroesMajorShim <- function(mjr) {
    .Call('icd9_icd9AddLeadingZeroesMajorShim', PACKAGE = 'icd9', mjr)
}

#' @rdname icd9AddLeadingZeroes
icd9AddLeadingZeroesShort <- function(icd9Short) {
    .Call('icd9_icd9AddLeadingZeroesShort', PACKAGE = 'icd9', icd9Short)
}

#' @rdname icd9AddLeadingZeroes
icd9AddLeadingZeroesDecimal <- function(icd9Decimal) {
    .Call('icd9_icd9AddLeadingZeroesDecimal', PACKAGE = 'icd9', icd9Decimal)
}

#' @title Add leading zeroes to incomplete ICD codes
#' @description Non-decimal ICD-9 codes with length<5 are often ambiguous. E.g.
#'   100 could be 1.00 10.0 or 100 if coded incorrectly. We must assume 100 is
#'   really 100
#' @template icd9-any
#' @template icd9-short
#' @template icd9-decimal
#' @template major
#' @return character vector of ICD codes (or major part thereof)
#' @keywords internal manip
icd9AddLeadingZeroes <- function(icd9, isShort) {
    .Call('icd9_icd9AddLeadingZeroes', PACKAGE = 'icd9', icd9, isShort)
}

icd9ExpandMinorShim <- function(mnr, isE = FALSE) {
    .Call('icd9_icd9ExpandMinorShim', PACKAGE = 'icd9', mnr, isE)
}

icd9ChildrenShortCpp <- function(icd9Short, onlyReal) {
    .Call('icd9_icd9ChildrenShortCpp', PACKAGE = 'icd9', icd9Short, onlyReal)
}

icd9ChildrenDecimalCpp <- function(icd9Decimal, onlyReal) {
    .Call('icd9_icd9ChildrenDecimalCpp', PACKAGE = 'icd9', icd9Decimal, onlyReal)
}

icd9ChildrenCpp <- function(icd9, isShort, onlyReal = TRUE) {
    .Call('icd9_icd9ChildrenCpp', PACKAGE = 'icd9', icd9, isShort, onlyReal)
}

#' @title match ICD9 codes
#' @description Finds children of \code{icd9Reference} and looks for \code{icd9} in the
#'   resulting vector.
#' @templateVar icd9AnyName "icd9,icd9Reference"
#' @template icd9-any
#' @template isShort
#' @param isShortReference logical, see argument \code{isShort}
#' @return logical vector of which icd9 match or are subcategory of
#'   \code{icd9Reference}
#' @keywords internal
icd9InReferenceCode <- function(icd9, icd9Reference, isShort, isShortReference = TRUE) {
    .Call('icd9_icd9InReferenceCode', PACKAGE = 'icd9', icd9, icd9Reference, isShort, isShortReference)
}

strimCpp <- function(s) {
    .Call('icd9_strimCpp', PACKAGE = 'icd9', s)
}

trimCpp <- function(sv) {
    .Call('icd9_trimCpp', PACKAGE = 'icd9', sv)
}

assertFactorOrCharacter <- function(x) {
    .Call('icd9_assertFactorOrCharacter', PACKAGE = 'icd9', x)
}

getOmpCores <- function() {
    .Call('icd9_getOmpCores', PACKAGE = 'icd9')
}

# Register entry points for exported C++ functions
methods::setLoadAction(function(ns) {
    .Call('icd9_RcppExport_registerCCallable', PACKAGE = 'icd9')
})
