% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/real.R
\name{get_leaf}
\alias{get_leaf}
\alias{get_leaf.default}
\alias{get_leaf.icd9cm}
\alias{get_leaf.icd9}
\title{Get billable ICD codes}
\usage{
get_leaf(...)

\method{get_leaf}{default}(x, short_code = guess_short(x), ...)

\method{get_leaf}{icd9cm}(x, short_code = guess_short(x),
  invert = FALSE, ...)

\method{get_leaf}{icd9}(...)
}
\arguments{
\item{...}{arguments passed on to other functions}

\item{x}{input vector of ICD codes}

\item{short_code}{single logical value which determines whether the ICD-9
code provided is in short (\code{TRUE}) or decimal (\code{FALSE}) form.
Where reasonable, this is guessed from the input data.}

\item{invert}{Single logical value. Returns the inverse of the result. E.g.
if seeking valid ICD-9 codes, the invalid ones are returned.}
}
\description{
Get billable ICD codes, implicitly, this refers to an ICD
  implementation which is specialized for a country, typically for billing,
  e.g. ICD-9-CM in the USA.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Get billable ICD codes, guessing whether ICD-9
or ICD-10, and code short vs decimal type.

\item \code{icd9cm}: Get billable ICD-9-CM codes

\item \code{icd9}: Get billable ICD-9 codes, which is currently
implemented assuming ICD-9-CM
}}

\keyword{internal}
