% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iaibase.R
\name{fit_cv}
\alias{fit_cv}
\title{Fits a grid search to the training data with cross-validation}
\usage{
fit_cv(grid, X, ...)
}
\arguments{
\item{grid}{The grid to fit.}

\item{X}{The features of the data.}

\item{...}{Other parameters, including zero or more target vectors as
required by the problem type. Refer to the Julia documentation for
available parameters.}
}
\description{
Julia Equivalent:
\href{https://docs.interpretable.ai/v3.1.1/IAIBase/reference/#IAI.fit_cv\%21-Tuple\%7BGridSearch\%7D}{\code{IAI.fit_cv!}}
}
\examples{
\dontrun{
X <- iris[, 1:4]
y <- iris$Species
grid <- iai::grid_search(
    iai::optimal_tree_classifier(max_depth = 1),
)
iai::fit_cv(grid, X, y)
}
}
