% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iaibase.R
\name{get_survival_curve_data}
\alias{get_survival_curve_data}
\title{get_survival_curve_data}
\usage{
get_survival_curve_data(curve)
}
\arguments{
\item{curve}{The curve to query.}
}
\description{
Extract the underlying data from a survival curve (as returned by
\code{predict} or \code{get_survival_curve})
}
\details{
The data is returned as a list with two keys: \code{times} containing the
time for each breakpoint on the curve, and \code{coefs} containing the
probability for each breakpoint on the curve.

Julia Equivalent:
\href{https://docs.interpretable.ai/IAIBase/stable/reference/#IAI.get_survival_curve_data}{\code{IAI.get_survival_curve_data}}
}
\examples{
\dontrun{iai::get_survival_curve_data(curve)}

}
