% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SQ.R
\name{SQ}
\alias{SQ}
\title{Estimation of Solar Quiet (SQ) Variation}
\usage{
SQ(data, si.v = si.v, wf = "la8")
}
\arguments{
\item{data}{a matrix or data frame of records of magnetic storm activity. Each column should contain records from an individual station. For more accurate estimate, at least two stations should be used.}

\item{si.v}{estimation of WISA from SAIndex function.}

\item{wf}{the type of the wavelet filter used. LA(8) filter is the default one.}
}
\value{
SQ the estimation of a non-constant solar quiet daily variation.
}
\description{
Estimate a non-constant solar quiet daily variation by using multiresolution analysis (MRA) and functional principal component analysis. The procedure removes the global signature of a ring current to eliminate the effect of the magnetic storm. The wavelet-based filtering and functional data analysis techniques are used to eliminate the daily periodic component. In order to get better Sq estimate it is necessary to use records from at least two stations.
}
\details{
\code{SQ} is a function for estimating solar quiet daily variation. Stations used in estimation of SQ need to be differ from stations used in estimating WISA. The resulting daily variation is non-constant, and its day-to-day variability is quantified by functional principal component scores. It uses \code{mra} to obtain MRA from the data after storm activity was removed. We compute the first PC rather than the first
PC of the raw magnetometer data with some seasonal adjustments which do not remove the storm activity from the Sq.
}
\examples{
\dontrun{
## example data
data(record)
coord=matrix(c(124.43, 19.23, 53.77,140.18,68.68,202.00,71.89,293.85),nrow=2,ncol=4)

## Estimation of SI index
index.sample<- SAIndex(record, coord, wf="la8")
si.v<-index.sample$SI

## example data of stations which are different from the ones that are used to estimate SI
## index.
## estimation of sq
Sq<-SQ (datasq, si.v=si.v, wf = "la8")
start.date="2001-3-1"
end.date="2001-4-30"
sqplot(Sq, Title="Sq variation", start = start.date, end=end.date, n.station=4,
      graphs.per.page=2, station.names=c("ABG","PHU","TUC","FRD"))
}
}
\references{
Maslova, P. Kokoszka, J. Sojka, L. Zhu (2010), Estimation of Sq variation by means of multiresolution and principal component analyses.
}
\seealso{
\code{\link{SAIndex}}
}

