% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estPD.R
\name{estPD}
\alias{estPD}
\title{Estimate asymptotic phylogenetic diversity}
\usage{
estPD(x, labels, phy, q = 0, datatype = "abundance", se = FALSE,
  conf = 0.95)
}
\arguments{
\item{x}{a vector/matrix/list of species abundances or a matrix of raw incidence table.\cr}

\item{labels}{a vector of species name for input data.\cr}

\item{phy}{a phylogenetic tree with \code{"phylog"} class.\cr}

\item{q}{a numeric value specifying the diversity order of Hill number.\cr}

\item{datatype}{data type of input data: individual-based abundance data (\code{datatype = "abundance"}), species by sampling-units incidence matrix (\code{datatype = "incidence_raw"}).}

\item{se}{a logical variable to calculate the bootstrap standard error and conf confidence interval.}

\item{conf}{a positive number < 1 specifying the level of confidence interval, default is 0.95.}
}
\value{
a data.frame with sample size and sample coverage.
}
\description{
\code{estPD}: Estimate asymptotic phylogenetic diversity with order q = 0, 1, 2.
}
\examples{
# abundance-based example
data(bird)
bird.abu <- bird$abun
bird.lab <- rownames(bird$abun)
bird.phy <- ade4::newick2phylog(bird$tre)
estPD(bird.abu, labels=bird.lab, phy=bird.phy, q=0, datatype="abundance")

# incidence_based example
bird.inc <- bird$inci
estPD(bird.inc, labels=bird.lab, phy=bird.phy, q=0, datatype="incidence_raw", se=TRUE)
}

