/*
 * Decompiled with CFR 0.152.
 */
package mrmc.gui;

import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DecimalFormat;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import mrmc.chart.exploreExpSize;
import mrmc.core.DBRecord;
import mrmc.core.InputFile;
import mrmc.core.StatTest;
import mrmc.gui.GUInterface;

public class SizePanel {
    public static String viewresultnew;
    private GUInterface GUI;
    private InputFile InputFile1;
    private DBRecord DBRecordSize;
    public JPanel JPanelSize = new JPanel();
    public JCheckBox sizeMleCheckBox;
    private JFrame reportFrame;
    public JRadioButton ButtonPairedReadersYes;
    public JRadioButton ButtonPairedReadersNo;
    public JRadioButton ButtonPairedNormalsYes;
    public JRadioButton ButtonPairedNormalsNo;
    public JRadioButton ButtonPairedDiseasedYes;
    public JRadioButton ButtonPairedDiseasedNo;
    public JTextField NumSplitPlotsJTextField;
    public JTextField NreaderJTextField;
    public JTextField NnormalJTextField;
    public JTextField NdiseaseJTextField;
    public JTextField SigLevelJTextField;
    public JTextField EffSizeJTextField;
    public JLabel SizeJLabel = new JLabel("Sizing Analysis: ");
    public JLabel SizeJLabelSqrtVar = new JLabel();
    public JLabel SizeJLabelTStat = new JLabel();
    public JLabel SizeJLabelPowerNormal = new JLabel();
    public JLabel SizeJLabelCINormal = new JLabel();
    public JLabel SizeJLabelDFBDG = new JLabel();
    public JLabel SizeJLabelLambdaBDG = new JLabel();
    public JLabel SizeJLabelPowerBDG = new JLabel();
    public JLabel SizeJLabelCIBDG = new JLabel();
    public JLabel SizeJLabelDFHillis = new JLabel();
    public JLabel SizeJLabelLambdaHillis = new JLabel();
    public JLabel SizeJLabelPowerHillis = new JLabel();
    public JLabel SizeJLabelCIHillis = new JLabel();
    JPanel SizePanelRow1;
    JPanel SizePanelRow2;
    JPanel SizePanelRow3;
    JPanel SizePanelRow4;
    JPanel SizePanelRow5;
    JPanel SizePanelRow6;
    public int numSplitPlots = 1;
    public int pairedNormalsFlag = 1;
    public int pairedDiseasedFlag = 1;
    public int pairedReadersFlag = 1;
    public double sigLevel;
    public double effSize;
    double[] statParms = new double[2];
    private String SEPA = ",";
    DecimalFormat twoDec = new DecimalFormat("0.00");
    DecimalFormat threeDec = new DecimalFormat("0.000");
    DecimalFormat fourDec = new DecimalFormat("0.0000");
    public DecimalFormat threeDecE = new DecimalFormat("0.000E0");
    DecimalFormat fiveDecE = new DecimalFormat("0.00000E0");

    public SizePanel() {
    }

    public SizePanel(GUInterface GUItemp) {
        this.GUI = GUItemp;
        this.DBRecordSize = this.GUI.DBRecordSize;
        this.JPanelSize.setLayout(new BoxLayout(this.JPanelSize, 1));
        this.SizePanelRow1 = this.setStudyDesign();
        this.SizePanelRow2 = new JPanel(new FlowLayout());
        this.SizePanelRow3 = new JPanel(new FlowLayout());
        this.SizePanelRow4 = new JPanel(new FlowLayout());
        this.SizePanelRow5 = new JPanel(new FlowLayout());
        this.SizePanelRow6 = new JPanel(new FlowLayout());
        this.sizeMleCheckBox = new JCheckBox("Size MLE");
        this.sizeMleCheckBox.setSelected(false);
        this.sizeMleCheckBox.addItemListener(new SizeMLEListener());
        this.SizePanelRow2.add(this.sizeMleCheckBox);
        this.SigLevelJTextField = new JTextField("0.05", 3);
        this.SizePanelRow2.add(new JLabel("Significance level"));
        this.SizePanelRow2.add(this.SigLevelJTextField);
        this.EffSizeJTextField = new JTextField("0.05", 3);
        this.SizePanelRow2.add(new JLabel("Effect Size"));
        this.SizePanelRow2.add(this.EffSizeJTextField);
        this.NreaderJTextField = new JTextField("0", 3);
        this.SizePanelRow2.add(new Label("#Reader"));
        this.SizePanelRow2.add(this.NreaderJTextField);
        this.NnormalJTextField = new JTextField("0", 3);
        this.SizePanelRow2.add(new Label("#Normal"));
        this.SizePanelRow2.add(this.NnormalJTextField);
        this.NdiseaseJTextField = new JTextField("0", 3);
        this.SizePanelRow2.add(new Label("#Diseased"));
        this.SizePanelRow2.add(this.NdiseaseJTextField);
        JButton sizeTrial = new JButton("Size a Trial");
        sizeTrial.addActionListener(new sizeTrialListener());
        this.SizePanelRow2.add(sizeTrial);
        JButton fullyTrial = new JButton("Explore Experiment Size");
        fullyTrial.addActionListener(new fullyTrialListener());
        this.SizePanelRow2.add(fullyTrial);
        this.SizePanelRow3.add(this.SizeJLabel);
        this.SizePanelRow3.add(this.SizeJLabelSqrtVar);
        this.SizePanelRow3.add(this.SizeJLabelTStat);
        this.SizePanelRow4.add(this.SizeJLabelPowerNormal);
        this.SizePanelRow4.add(this.SizeJLabelCINormal);
        this.SizePanelRow5.add(this.SizeJLabelDFBDG);
        this.SizePanelRow5.add(this.SizeJLabelLambdaBDG);
        this.SizePanelRow5.add(this.SizeJLabelPowerBDG);
        this.SizePanelRow5.add(this.SizeJLabelCIBDG);
        JButton sizeHillis = new JButton("Hillis Approx");
        JPanel SizePanelRow6 = new JPanel();
        sizeHillis.addActionListener(new SizeHillisButtonListener());
        SizePanelRow6.add(sizeHillis);
        this.JPanelSize.add(this.SizePanelRow1);
        this.JPanelSize.add(this.SizePanelRow2);
        this.JPanelSize.add(this.SizePanelRow3);
        this.JPanelSize.add(this.SizePanelRow4);
        this.JPanelSize.add(this.SizePanelRow5);
        this.JPanelSize.add(SizePanelRow6);
    }

    public JPanel setStudyDesign() {
        JPanel JPanelStudyDesign = new JPanel(new FlowLayout(0));
        JPanelStudyDesign.add(new JLabel("Study Design:  "));
        this.NumSplitPlotsJTextField = new JTextField("1", 3);
        JPanelStudyDesign.add(new JLabel("# of Split-Plot Groups"));
        JPanelStudyDesign.add(this.NumSplitPlotsJTextField);
        this.NumSplitPlotsJTextField.addFocusListener(new NumSplitPlotsListener());
        this.ButtonPairedReadersYes = new JRadioButton("Yes");
        this.ButtonPairedReadersYes.setActionCommand("Yes");
        this.ButtonPairedReadersNo = new JRadioButton("No");
        this.ButtonPairedReadersNo.setActionCommand("No");
        if (this.pairedReadersFlag == 1) {
            this.ButtonPairedReadersYes.setSelected(true);
        } else {
            this.ButtonPairedReadersNo.setSelected(true);
        }
        ButtonGroup pairedRGroup = new ButtonGroup();
        pairedRGroup.add(this.ButtonPairedReadersYes);
        pairedRGroup.add(this.ButtonPairedReadersNo);
        PairedRListener pairedReaders = new PairedRListener();
        this.ButtonPairedReadersYes.addActionListener(pairedReaders);
        this.ButtonPairedReadersNo.addActionListener(pairedReaders);
        JPanelStudyDesign.add(new JLabel("    Paired Readers? "));
        JPanelStudyDesign.add(this.ButtonPairedReadersYes);
        JPanelStudyDesign.add(this.ButtonPairedReadersNo);
        this.ButtonPairedNormalsYes = new JRadioButton("Yes");
        this.ButtonPairedNormalsYes.setActionCommand("Yes");
        this.ButtonPairedNormalsNo = new JRadioButton("No");
        this.ButtonPairedNormalsNo.setActionCommand("No");
        if (this.pairedNormalsFlag == 1) {
            this.ButtonPairedNormalsYes.setSelected(true);
        } else {
            this.ButtonPairedNormalsNo.setSelected(true);
        }
        ButtonGroup pairedNGroup = new ButtonGroup();
        pairedNGroup.add(this.ButtonPairedNormalsYes);
        pairedNGroup.add(this.ButtonPairedNormalsNo);
        PairedNListener pairedNormals = new PairedNListener();
        this.ButtonPairedNormalsYes.addActionListener(pairedNormals);
        this.ButtonPairedNormalsNo.addActionListener(pairedNormals);
        JPanelStudyDesign.add(new JLabel("    Pair Normal Cases? "));
        JPanelStudyDesign.add(this.ButtonPairedNormalsYes);
        JPanelStudyDesign.add(this.ButtonPairedNormalsNo);
        this.ButtonPairedDiseasedYes = new JRadioButton("Yes");
        this.ButtonPairedDiseasedYes.setActionCommand("Yes");
        this.ButtonPairedDiseasedNo = new JRadioButton("No");
        this.ButtonPairedDiseasedNo.setActionCommand("No");
        if (this.pairedDiseasedFlag == 1) {
            this.ButtonPairedDiseasedYes.setSelected(true);
        } else {
            this.ButtonPairedDiseasedNo.setSelected(true);
        }
        ButtonGroup pairedDGroup = new ButtonGroup();
        pairedDGroup.add(this.ButtonPairedDiseasedYes);
        pairedDGroup.add(this.ButtonPairedDiseasedNo);
        PairedDListener pairedDiseased = new PairedDListener();
        this.ButtonPairedDiseasedYes.addActionListener(pairedDiseased);
        this.ButtonPairedDiseasedNo.addActionListener(pairedDiseased);
        JPanelStudyDesign.add(new JLabel("    Pair Disease Cases? "));
        JPanelStudyDesign.add(this.ButtonPairedDiseasedYes);
        JPanelStudyDesign.add(this.ButtonPairedDiseasedNo);
        return JPanelStudyDesign;
    }

    void resetSizePanel() {
        this.DBRecordSize.totalVar = -1.0;
        this.SizeJLabelSqrtVar.setText("S.E=");
        this.SizeJLabelPowerNormal.setText("Large Sample Approx(Normal),  Power=");
        this.SizeJLabelDFBDG.setText("          BDG:  df=");
        this.SizeJLabelLambdaBDG.setText(",  Lambda=");
        this.SizeJLabelPowerBDG.setText(",  Power=");
        this.SizeJLabelDFHillis.setText("df=");
        this.SizeJLabelLambdaHillis.setText("Lambda=");
        this.SizeJLabelPowerHillis.setText("Power=");
        this.NumSplitPlotsJTextField.setText("1");
        this.numSplitPlots = 1;
        this.ButtonPairedReadersYes.setSelected(true);
        this.ButtonPairedReadersNo.setSelected(false);
        this.pairedReadersFlag = 1;
        this.ButtonPairedNormalsYes.setSelected(true);
        this.ButtonPairedNormalsNo.setSelected(false);
        this.pairedNormalsFlag = 1;
        this.ButtonPairedDiseasedYes.setSelected(true);
        this.ButtonPairedDiseasedNo.setSelected(false);
        this.pairedDiseasedFlag = 1;
    }

    public void setSizePanel() {
        StatTest testSize = this.DBRecordSize.testSize;
        String output = "S.E=" + this.threeDecE.format(this.DBRecordSize.SE);
        this.SizeJLabelSqrtVar.setText(output);
        output = "Large Sample Approx(Normal) ,  Power= " + this.twoDec.format(testSize.powerNormal);
        this.SizeJLabelPowerNormal.setText(output);
        output = ",  Conf. Int.=(" + this.fourDec.format(testSize.ciBotNormal) + ", " + this.fourDec.format(testSize.ciTopNormal) + ")";
        output = "          BDG:  df= " + this.twoDec.format(testSize.DF_BDG);
        this.SizeJLabelDFBDG.setText(output);
        output = ",  Lambda= " + this.twoDec.format(testSize.lambdaBDG);
        this.SizeJLabelLambdaBDG.setText(output);
        output = ",  Power= " + this.twoDec.format(testSize.powerBDG);
        this.SizeJLabelPowerBDG.setText(output);
        output = ",  Conf. Int.=(" + this.fourDec.format(testSize.ciBotBDG) + ", " + this.fourDec.format(testSize.ciTopBDG) + ")";
        if (this.numSplitPlots == 1 && this.pairedReadersFlag == 1 && this.pairedNormalsFlag == 1 && this.pairedDiseasedFlag == 1) {
            output = "df= " + this.twoDec.format(testSize.DF_Hillis);
            this.SizeJLabelDFHillis.setText(output);
            output = "Lambda= " + this.twoDec.format(testSize.lambdaHillis);
            this.SizeJLabelLambdaHillis.setText(output);
            output = "Power= " + this.twoDec.format(testSize.powerHillis);
            this.SizeJLabelPowerHillis.setText(output);
            output = "Conf. Int.=(" + this.fourDec.format(testSize.ciBotHillis) + ", " + this.fourDec.format(testSize.ciTopHillis) + ")";
        } else {
            this.SizeJLabelDFHillis.setText("df=");
            this.SizeJLabelLambdaHillis.setText("Lambda=");
            this.SizeJLabelPowerHillis.setText("Power=");
        }
    }

    public String getSizeResults() {
        String results = this.SizeJLabelSqrtVar.getText();
        results = String.valueOf(results) + "\t" + this.SizeJLabelTStat.getText();
        results = String.valueOf(results) + "\t" + this.SizeJLabelPowerNormal.getText();
        results = String.valueOf(results) + "\t" + this.SizeJLabelCINormal.getText();
        results = String.valueOf(results) + "\r\n";
        results = String.valueOf(results) + "\t" + this.SizeJLabelDFBDG.getText();
        results = String.valueOf(results) + "\t" + this.SizeJLabelPowerBDG.getText();
        results = String.valueOf(results) + "\t" + this.SizeJLabelCIBDG.getText();
        results = String.valueOf(results) + "\r\n";
        if (this.DBRecordSize.flagFullyCrossed) {
            results = String.valueOf(results) + "Hillis:";
            results = String.valueOf(results) + "\t" + this.SizeJLabelDFHillis.getText();
            results = String.valueOf(results) + "\t" + this.SizeJLabelPowerHillis.getText();
            results = String.valueOf(results) + "\t" + this.SizeJLabelCIHillis.getText();
        } else {
            results = String.valueOf(results) + "The Hillis degrees of freedom are not calculated when the data is not fully crossed.";
        }
        return results;
    }

    public String exportSizeResults() {
        String results = String.valueOf(this.SizeJLabelSqrtVar.getText()) + "\r\n";
        results = String.valueOf(results) + this.SizeJLabelTStat.getText();
        results = String.valueOf(results) + this.SizeJLabelPowerNormal.getText();
        results = String.valueOf(results) + "\r\n";
        results = String.valueOf(results) + this.SizeJLabelDFBDG.getText().trim();
        results = String.valueOf(results) + this.SizeJLabelPowerBDG.getText();
        results = String.valueOf(results) + "\r\n";
        if (this.DBRecordSize.flagFullyCrossed) {
            results = String.valueOf(results) + "Hills:" + this.SizeJLabelDFHillis.getText();
            results = String.valueOf(results) + ", " + this.SizeJLabelPowerHillis.getText();
        } else {
            results = String.valueOf(results) + "The Hillis degrees of freedom are not calculated when the data is not fully crossed.";
        }
        return results;
    }

    public class NumSplitPlotsListener
    implements FocusListener {
        @Override
        public void focusGained(FocusEvent arg0) {
        }

        @Override
        public void focusLost(FocusEvent arg0) {
            SizePanel.this.numSplitPlots = Integer.parseInt(SizePanel.this.NumSplitPlotsJTextField.getText());
        }
    }

    class PairedDListener
    implements ActionListener {
        PairedDListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String str = e.getActionCommand();
            if (str == "Yes") {
                SizePanel.this.pairedDiseasedFlag = 1;
            }
            if (str == "No") {
                SizePanel.this.pairedDiseasedFlag = 0;
            }
        }
    }

    class PairedNListener
    implements ActionListener {
        PairedNListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String str = e.getActionCommand();
            if (str == "Yes") {
                SizePanel.this.pairedNormalsFlag = 1;
            }
            if (str == "No") {
                SizePanel.this.pairedNormalsFlag = 0;
            }
        }
    }

    class PairedRListener
    implements ActionListener {
        PairedRListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String str = e.getActionCommand();
            if (str == "Yes") {
                SizePanel.this.pairedReadersFlag = 1;
            }
            if (str == "No") {
                SizePanel.this.pairedReadersFlag = 0;
            }
        }
    }

    public class SizeHillisButtonListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            String hillisValues = ((SizePanel)SizePanel.this).DBRecordSize.flagFullyCrossed ? "Hillis 2011:\n" + SizePanel.this.SizeJLabelDFHillis.getText() + "\n" + SizePanel.this.SizeJLabelLambdaHillis.getText() + "\n" + SizePanel.this.SizeJLabelPowerHillis.getText() + "\n" + SizePanel.this.SizeJLabelCIHillis.getText() : "The Hillis degrees of freedom are not calculated when the data is not fully crossed.";
            JOptionPane.showMessageDialog(SizePanel.this.reportFrame, hillisValues, "Hillis Approximation", -1);
        }
    }

    class SizeMLEListener
    implements ItemListener {
        SizeMLEListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            ((SizePanel)SizePanel.this).DBRecordSize.flagMLE = SizePanel.this.sizeMleCheckBox.isSelected() ? 1 : 0;
            ((SizePanel)SizePanel.this).GUI.SizePanel1.resetSizePanel();
        }
    }

    class fullyTrialListener
    implements ActionListener {
        fullyTrialListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                if (((SizePanel)SizePanel.this).GUI.DBRecordStat.totalVar <= 0.0) {
                    JOptionPane.showMessageDialog(((SizePanel)SizePanel.this).GUI.MRMCobject.getFrame(), "Must perform variance analysis first.", "Error", 0);
                    return;
                }
                SizePanel.this.sigLevel = Double.parseDouble(SizePanel.this.SigLevelJTextField.getText());
                SizePanel.this.effSize = Double.parseDouble(SizePanel.this.EffSizeJTextField.getText());
                JOptionPane.showMessageDialog(((SizePanel)SizePanel.this).GUI.MRMCobject.getFrame(), "All results in this feature assume fully crossed study", "Notice", 1);
                exploreExpSize exploreExpSize2 = new exploreExpSize(SizePanel.this.DBRecordSize, SizePanel.this.GUI, ((SizePanel)SizePanel.this).GUI.SizePanel1);
            }
            catch (NumberFormatException e1) {
                JOptionPane.showMessageDialog(SizePanel.this.reportFrame, "Invalid Input", "Error", 0);
            }
        }
    }

    class sizeTrialListener
    implements ActionListener {
        sizeTrialListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                ((SizePanel)SizePanel.this).DBRecordSize.Nreader = Integer.parseInt(SizePanel.this.NreaderJTextField.getText());
                ((SizePanel)SizePanel.this).DBRecordSize.Nnormal = Integer.parseInt(SizePanel.this.NnormalJTextField.getText());
                ((SizePanel)SizePanel.this).DBRecordSize.Ndisease = Integer.parseInt(SizePanel.this.NdiseaseJTextField.getText());
                SizePanel.this.sigLevel = Double.parseDouble(SizePanel.this.SigLevelJTextField.getText());
                SizePanel.this.effSize = Double.parseDouble(SizePanel.this.EffSizeJTextField.getText());
                boolean sizesucceed = SizePanel.this.DBRecordSize.DBRecordSizeFill(((SizePanel)SizePanel.this).GUI.SizePanel1);
                if (!sizesucceed) {
                    return;
                }
                SizePanel.this.setSizePanel();
            }
            catch (NumberFormatException e1) {
                JOptionPane.showMessageDialog(SizePanel.this.reportFrame, "Invalid Input", "Error", 0);
            }
        }
    }
}

