% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_perm.R
\name{get_perm}
\alias{get_perm}
\title{Get Permutation}
\usage{
get_perm(m, n, corr)
}
\arguments{
\item{m}{An integer. Order of \eqn{G_1}.}

\item{n}{An integer. Order of \eqn{G_2}.}

\item{corr}{A matrix or a data frame. Matching correspondence with the first
and second columns correspond to indices in \eqn{G_1} and \eqn{G_2} respectively.}
}
\value{
\code{get_perm} returns an \code{m-by-n} sparse permutation matrix or whose
  submatrix is a permutation matrix if only parts of nodes from both graphs get
  matched or in the case of matching graphs of different order.
}
\description{
Get an \code{m-by-n} permutation matrix according to the mapping
  correspondence.
}
\examples{
# returns a permutation matrix: m=n, all the nodes get matched
corr <- data.frame(corr_A = c(1,2,3,4), corr_B = c(1,4,2,3))
get_perm(4, 4, corr)

# submatrix is a permutation matrix: parts of graphs get matched
get_perm(5, 6, corr)

}
